/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.upload;

import ca.nrc.cadc.dali.tables.votable.VOTableWriter;
import ca.nrc.cadc.search.upload.TableDataElement;
import ca.nrc.cadc.search.upload.TableDataXMLOutputProcessor;
import ca.nrc.cadc.search.upload.UploadResults;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Iterator;
import org.apache.commons.io.LineIterator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.output.support.XMLOutputProcessor;

public class StreamingVOTableWriter
extends VOTableWriter {
    private static final Logger LOGGER = LogManager.getLogger(StreamingVOTableWriter.class);
    private UploadResults uploadResults;

    public StreamingVOTableWriter(UploadResults uploadResults) {
        this.uploadResults = uploadResults;
    }

    public void write(InputStream in, OutputStream out) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        LineIterator iterator = new LineIterator((Reader)reader);
        this.write((Iterator<String>)iterator, out);
    }

    public void write(Iterator<String> iterator, OutputStream out) throws IOException {
        Document document = this.createDocument();
        Element root = document.getRootElement();
        Namespace namespace = root.getNamespace();
        Element resource = new Element("RESOURCE", namespace);
        resource.setAttribute("type", "results");
        root.addContent((Content)resource);
        Element table = new Element("TABLE", namespace);
        resource.addContent((Content)table);
        table.addContent((Content)this.getField("LineNumber", "int", namespace));
        table.addContent((Content)this.getField("Target", "char", namespace));
        table.addContent((Content)this.getField("RA", "double", namespace));
        table.addContent((Content)this.getField("DEC", "double", namespace));
        table.addContent((Content)this.getField("radius", "double", namespace));
        table.addContent((Content)this.getField("position", "double", "circle", 3, namespace));
        table.addContent((Content)this.getField("TargetError", "char", namespace));
        Element data = new Element("DATA", namespace);
        table.addContent((Content)data);
        TableDataElement tableData = new TableDataElement(iterator, namespace, this.uploadResults);
        data.addContent((Content)tableData);
        LOGGER.debug((Object)"Writing out to Output Stream.");
        this.write(document, out);
    }

    protected void write(Document document, OutputStream out) throws IOException {
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat(), (XMLOutputProcessor)new TableDataXMLOutputProcessor(Integer.MAX_VALUE));
        outputter.output(document, out);
    }

    private Element getField(String name, String datatype, Namespace namespace) {
        Element element = new Element("FIELD", namespace);
        element.setAttribute("name", name);
        element.setAttribute("datatype", datatype);
        if (datatype.equalsIgnoreCase("char")) {
            element.setAttribute("arraysize", "*");
        }
        return element;
    }

    private Element getField(String name, String datatype, String xtype, Integer arraySize, Namespace namespace) {
        Element element = new Element("FIELD", namespace);
        element.setAttribute("name", name);
        element.setAttribute("datatype", datatype);
        element.setAttribute("xtype", xtype);
        element.setAttribute("arraysize", arraySize.toString());
        return element;
    }
}

