/*
 * Decompiled with CFR 0.152.
 */
package ca.nrc.cadc.search.upload;

import ca.nrc.cadc.search.upload.TableDataElement;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.output.support.AbstractXMLOutputProcessor;
import org.jdom2.output.support.FormatStack;
import org.jdom2.util.NamespaceStack;

public class TableDataXMLOutputProcessor
extends AbstractXMLOutputProcessor {
    private static final Logger LOGGER = Logger.getLogger(TableDataXMLOutputProcessor.class);
    private static final String NEW_LINE = System.getProperty("line.separator");
    private int rowCount;
    private int maxRows;
    private boolean error;

    public TableDataXMLOutputProcessor(int maxRows) {
        this.maxRows = maxRows;
        this.rowCount = 0;
        this.error = false;
    }

    protected void printElement(Writer out, FormatStack fstack, NamespaceStack nstack, Element element) throws IOException {
        if (element.getName().equalsIgnoreCase("TABLE")) {
            Element info;
            super.printElement(out, fstack, nstack, element);
            if (this.rowCount > this.maxRows) {
                out.write(NEW_LINE);
                info = new Element("INFO", element.getNamespace());
                info.setAttribute("name", "QUERY_STATUS");
                info.setAttribute("value", "OVERFLOW");
                super.printElement(out, fstack, nstack, info);
            }
            if (this.error) {
                out.write(NEW_LINE);
                info = new Element("INFO", element.getNamespace());
                info.setAttribute("name", "QUERY_STATUS");
                info.setAttribute("value", "ERROR");
                super.printElement(out, fstack, nstack, info);
            }
        } else if (element instanceof TableDataElement) {
            out.write("<");
            out.write(element.getQualifiedName());
            out.write(">");
            out.write(NEW_LINE);
            List contents = element.getContent();
            for (Content row : contents) {
                ++this.rowCount;
                if (this.rowCount > this.maxRows) break;
                out.write(fstack.getLevelIndent());
                try {
                    super.printElement(out, fstack, nstack, (Element)row);
                }
                catch (Throwable t) {
                    LOGGER.error((Object)"failed while iterating over TableDataElement", t);
                    this.error = true;
                    break;
                }
                out.write(NEW_LINE);
            }
            out.write(fstack.getIndent());
            out.write("</");
            out.write(element.getQualifiedName());
            out.write(">");
        } else {
            super.printElement(out, fstack, nstack, element);
        }
    }
}

