/*
 * Decompiled with CFR 0.152.
 */
package jsky.coords;

import java.awt.geom.Point2D;
import jsky.coords.WCSKeywordProvider;
import jsky.coords.WorldCoordinateConverter;
import jsky.coords.platepos;
import jsky.coords.wcscon;
import jsky.coords.worldpos;

public class WCSTransform
implements WorldCoordinateConverter {
    double xref;
    double yref;
    double xrefpix;
    double yrefpix;
    double xinc;
    double yinc;
    double rot;
    double crot;
    double srot;
    double cd11;
    double cd12;
    double cd21;
    double cd22;
    double dc11;
    double dc12;
    double dc21;
    double dc22;
    double mrot;
    double cmrot;
    double smrot;
    double xmpix;
    double ympix;
    double equinox;
    double epoch;
    double nxpix;
    double nypix;
    double plate_ra;
    double plate_dec;
    double plate_scale;
    double x_pixel_offset;
    double y_pixel_offset;
    double x_pixel_size;
    double y_pixel_size;
    double[] ppo_coeff = new double[6];
    double[] amd_x_coeff = new double[20];
    double[] amd_y_coeff = new double[20];
    double xpix;
    double ypix;
    double xpos;
    double ypos;
    int pcode;
    int changesys;
    int printsys;
    int ndec;
    int degout;
    int tabsys;
    int rotmat;
    int coorflip;
    int offscl;
    int plate_fit = 0;
    int wcson;
    int detector;
    String instrument = "";
    String c1type = "";
    String c2type = "";
    String[] ctypes = new String[]{"-SIN", "-TAN", "-ARC", "-NCP", "-GLS", "-MER", "-AIT", "-STG"};
    String ptype = "";
    String radecsys = "";
    String sysout = "";
    String center = "";
    double fCenterRa;
    double fCenterDec;
    double fHalfWidthRa;
    double fHalfWidthDec;
    double fWidthDeg;
    double fHeightDeg;
    Point2D.Double degPerPixel;
    public static final String NO_WCS_IN_HEADER_MESSAGE = "The header does not contain a valid world coordinate system.".intern();

    public static double degrad(double x) {
        return x * Math.PI / 180.0;
    }

    public static double raddeg(double x) {
        return x * 180.0 / Math.PI;
    }

    public static double hrdeg(double x) {
        return x * 15.0;
    }

    public static double deghr(double x) {
        return x / 15.0;
    }

    public static double hrrad(double x) {
        return WCSTransform.degrad(WCSTransform.hrdeg(x));
    }

    public static double radhr(double x) {
        return WCSTransform.deghr(WCSTransform.raddeg(x));
    }

    public WCSTransform(WCSKeywordProvider head) {
        this.nxpix = head.getDoubleValue("NAXIS1");
        this.nypix = head.getDoubleValue("NAXIS2");
        this.xmpix = 0.5 * this.nxpix;
        this.ympix = 0.5 * this.nypix;
        this.mrot = 0.0;
        this.equinox = head.getDoubleValue("EQUINOX");
        if (head.findKey("PLTRAH")) {
            this.plate_fit = 1;
            double rah = head.getDoubleValue("PLTRAH");
            double ram = head.getDoubleValue("PLTRAM");
            double ras = head.getDoubleValue("PLTRAS");
            double ra_hours = rah + ram / 60.0 + ras / 3600.0;
            this.plate_ra = WCSTransform.hrrad(ra_hours);
            int decsign = 43;
            String signString = head.getStringValue("PLTDECSN");
            if (signString != null) {
                decsign = signString.charAt(0);
            }
            double dsign = decsign == 45 ? -1.0 : 1.0;
            double decd = head.getDoubleValue("PLTDECD");
            double decm = head.getDoubleValue("PLTDECM");
            double decs = head.getDoubleValue("PLTDECS");
            double dec_deg = dsign * (decd + decm / 60.0 + decs / 3600.0);
            this.plate_dec = WCSTransform.degrad(dec_deg);
            int ieq = (int)this.equinox;
            this.radecsys = ieq == 1950 ? "FK4" : "FK5";
            this.epoch = this.equinox;
            if (head.findKey("EPOCH")) {
                this.epoch = head.getDoubleValue("EPOCH");
            }
            this.plate_scale = head.getDoubleValue("PLTSCALE");
            this.x_pixel_size = head.getDoubleValue("XPIXELSZ");
            this.y_pixel_size = head.getDoubleValue("YPIXELSZ");
            this.x_pixel_offset = head.getDoubleValue("CNPIX1");
            this.y_pixel_offset = head.getDoubleValue("CNPIX2");
            this.ppo_coeff[0] = head.getDoubleValue("PPO1");
            this.ppo_coeff[1] = head.getDoubleValue("PPO2");
            this.ppo_coeff[2] = head.getDoubleValue("PPO3");
            this.ppo_coeff[3] = head.getDoubleValue("PPO4");
            this.ppo_coeff[4] = head.getDoubleValue("PPO5");
            this.ppo_coeff[5] = head.getDoubleValue("PPO6");
            this.amd_x_coeff[0] = head.getDoubleValue("AMDX1");
            this.amd_x_coeff[1] = head.getDoubleValue("AMDX2");
            this.amd_x_coeff[2] = head.getDoubleValue("AMDX3");
            this.amd_x_coeff[3] = head.getDoubleValue("AMDX4");
            this.amd_x_coeff[4] = head.getDoubleValue("AMDX5");
            this.amd_x_coeff[5] = head.getDoubleValue("AMDX6");
            this.amd_x_coeff[6] = head.getDoubleValue("AMDX7");
            this.amd_x_coeff[7] = head.getDoubleValue("AMDX8");
            this.amd_x_coeff[8] = head.getDoubleValue("AMDX9");
            this.amd_x_coeff[9] = head.getDoubleValue("AMDX10");
            this.amd_x_coeff[10] = head.getDoubleValue("AMDX11");
            this.amd_x_coeff[11] = head.getDoubleValue("AMDX12");
            this.amd_x_coeff[12] = head.getDoubleValue("AMDX13");
            this.amd_x_coeff[13] = head.getDoubleValue("AMDX14");
            this.amd_x_coeff[14] = head.getDoubleValue("AMDX15");
            this.amd_x_coeff[15] = head.getDoubleValue("AMDX16");
            this.amd_x_coeff[16] = head.getDoubleValue("AMDX17");
            this.amd_x_coeff[17] = head.getDoubleValue("AMDX18");
            this.amd_x_coeff[18] = head.getDoubleValue("AMDX19");
            this.amd_x_coeff[19] = head.getDoubleValue("AMDX20");
            this.amd_y_coeff[0] = head.getDoubleValue("AMDY1");
            this.amd_y_coeff[1] = head.getDoubleValue("AMDY2");
            this.amd_y_coeff[2] = head.getDoubleValue("AMDY3");
            this.amd_y_coeff[3] = head.getDoubleValue("AMDY4");
            this.amd_y_coeff[4] = head.getDoubleValue("AMDY5");
            this.amd_y_coeff[5] = head.getDoubleValue("AMDY6");
            this.amd_y_coeff[6] = head.getDoubleValue("AMDY7");
            this.amd_y_coeff[7] = head.getDoubleValue("AMDY8");
            this.amd_y_coeff[8] = head.getDoubleValue("AMDY9");
            this.amd_y_coeff[9] = head.getDoubleValue("AMDY10");
            this.amd_y_coeff[10] = head.getDoubleValue("AMDY11");
            this.amd_y_coeff[11] = head.getDoubleValue("AMDY12");
            this.amd_y_coeff[12] = head.getDoubleValue("AMDY13");
            this.amd_y_coeff[13] = head.getDoubleValue("AMDY14");
            this.amd_y_coeff[14] = head.getDoubleValue("AMDY15");
            this.amd_y_coeff[15] = head.getDoubleValue("AMDY16");
            this.amd_y_coeff[16] = head.getDoubleValue("AMDY17");
            this.amd_y_coeff[17] = head.getDoubleValue("AMDY18");
            this.amd_y_coeff[18] = head.getDoubleValue("AMDY19");
            this.amd_y_coeff[19] = head.getDoubleValue("AMDY20");
            this.wcson = 1;
            this.c1type = "RA-";
            this.c2type = "DEC";
            this.ptype = "PLATE";
            this.degout = 0;
            this.ndec = 3;
        } else {
            String wcstemp = head.getStringValue("CTYPE1");
            if (wcstemp != null) {
                int wcstempLength = wcstemp.length();
                if (wcstemp.startsWith("LINEAR")) {
                    this.pcode = 0;
                    this.c1type = wcstemp;
                    this.ptype = wcstemp;
                } else if (wcstemp.startsWith("PIXEL")) {
                    this.pcode = -1;
                    this.c1type = wcstemp;
                    this.ptype = wcstemp;
                } else if (wcstempLength > 1 && (wcstemp.charAt(0) == 'R' || wcstemp.charAt(0) == 'D' || wcstemp.charAt(0) == 'A' || wcstemp.charAt(1) == 'L')) {
                    this.c1type = wcstemp.substring(0, 2);
                    if (wcstempLength > 2 && wcstemp.charAt(2) != '-') {
                        this.c1type = this.c1type + wcstemp.charAt(2);
                    }
                    if (wcstempLength > 3 && wcstemp.charAt(3) != '-') {
                        this.c1type = this.c1type + wcstemp.charAt(3);
                    }
                    if (wcstempLength > 4) {
                        this.ptype = wcstemp.substring(3, 7);
                    }
                    this.pcode = 0;
                    for (int i = 0; i < 8; ++i) {
                        if (!this.ptype.startsWith(this.ctypes[i])) continue;
                        this.pcode = i + 1;
                        break;
                    }
                } else {
                    System.err.println("WCSINIT: CTYPE1 not sky coordinates or LINEAR -> no WCS");
                    throw new IllegalArgumentException();
                }
                wcstemp = head.getStringValue("CTYPE2");
                if (wcstemp == null) {
                    System.err.println("WCSINIT: No CTYPE2 -> no WCS");
                    throw new IllegalArgumentException(NO_WCS_IN_HEADER_MESSAGE);
                }
                wcstempLength = wcstemp.length();
                if (wcstemp.startsWith("LINEAR")) {
                    this.pcode = 0;
                    this.c2type = wcstemp;
                } else if (wcstemp.startsWith("PIXEL")) {
                    this.pcode = -1;
                    this.c2type = wcstemp;
                } else if (wcstempLength > 1 && (wcstemp.charAt(0) == 'R' || wcstemp.charAt(0) == 'D' || wcstemp.charAt(0) == 'A' || wcstemp.charAt(1) == 'L')) {
                    this.c2type = wcstemp.substring(0, 2);
                    if (wcstempLength > 2 && wcstemp.charAt(2) != '-') {
                        this.c2type = this.c2type + wcstemp.charAt(2);
                    }
                    if (wcstempLength > 3 && wcstemp.charAt(3) != '-') {
                        this.c2type = this.c2type + wcstemp.charAt(3);
                    }
                    this.coorflip = this.c1type.startsWith("DEC") || this.c1type.startsWith("GLAT") ? 1 : 0;
                    if (wcstemp.charAt(1) == 'L' || wcstemp.charAt(0) == 'A') {
                        this.degout = 1;
                        this.ndec = 5;
                    } else {
                        this.degout = 0;
                        this.ndec = 3;
                    }
                } else {
                    System.err.println("WCSINIT: CTYPE2 not sky coordinates or LINEAR -> no WCS");
                    throw new IllegalArgumentException(NO_WCS_IN_HEADER_MESSAGE);
                }
                this.xrefpix = head.getDoubleValue("CRPIX1", 1.0);
                this.yrefpix = head.getDoubleValue("CRPIX2", 1.0);
                this.xref = head.getDoubleValue("CRVAL1", 1.0);
                this.yref = head.getDoubleValue("CRVAL2", 1.0);
                this.xinc = head.getDoubleValue("CDELT1");
                if (this.xinc != 0.0) {
                    this.yinc = head.getDoubleValue("CDELT2", this.xinc);
                    this.rot = head.getDoubleValue("CROTA1", 0.0);
                    if (this.rot == 0.0) {
                        this.rot = head.getDoubleValue("CROTA2");
                    }
                    this.cd11 = 0.0;
                    this.cd21 = 0.0;
                    this.cd12 = 0.0;
                    this.cd22 = 0.0;
                    this.rotmat = 0;
                } else {
                    this.cd11 = head.getDoubleValue("CD1_1");
                    if (this.cd11 != 0.0) {
                        this.rotmat = 1;
                        this.cd12 = head.getDoubleValue("CD1_2", 0.0);
                        this.cd21 = head.getDoubleValue("CD2_1", 0.0);
                        this.cd22 = head.getDoubleValue("CD2_2", this.cd11);
                        double cddet = this.cd11 * this.cd22 - this.cd12 * this.cd21;
                        if (cddet != 0.0) {
                            this.dc11 = this.cd22 / cddet;
                            this.dc12 = -this.cd12 / cddet;
                            this.dc21 = -this.cd21 / cddet;
                            this.dc22 = this.cd11 / cddet;
                        }
                        this.xinc = Math.sqrt(this.cd11 * this.cd11 + this.cd21 * this.cd21);
                        this.yinc = Math.sqrt(this.cd12 * this.cd12 + this.cd22 * this.cd22);
                        if (this.cd11 * this.cd11 - this.cd12 * this.cd12 < 0.0) {
                            if (this.c1type.startsWith("RA") || this.c1type.startsWith("GLON")) {
                                this.xinc = -this.xinc;
                            }
                            if (this.c2type.startsWith("RA") || this.c2type.startsWith("GLON")) {
                                this.yinc = -this.yinc;
                            }
                            this.rot = WCSTransform.raddeg(Math.atan2(-this.cd12, this.cd22));
                        } else {
                            this.rot = WCSTransform.raddeg(Math.atan2(this.cd12, this.cd22));
                        }
                    } else {
                        this.xinc = 1.0;
                        this.yinc = 1.0;
                        System.err.println("WCSINIT: setting CDELT to 1");
                    }
                }
                this.xmpix = head.getDoubleValue("CCPIX1");
                this.ympix = head.getDoubleValue("CCPIX2");
                this.mrot = head.getDoubleValue("CCROT1");
                if (this.ptype.startsWith("LINEAR") && this.ptype.startsWith("PIXEL")) {
                    this.degout = -1;
                } else {
                    this.wcseq(head);
                }
                this.wcson = 1;
            } else if (head.findKey("SECPIX") || head.findKey("PIXSCAL1") || head.findKey("SECPIX1")) {
                double secpix = head.getDoubleValue("SECPIX", 0.0);
                if (secpix == 0.0) {
                    secpix = head.getDoubleValue("SECPIX1", 0.0);
                    if (secpix != 0.0) {
                        this.xinc = -secpix / 3600.0;
                        secpix = head.getDoubleValue("SECPIX2", 0.0);
                        this.yinc = secpix / 3600.0;
                    } else {
                        secpix = head.getDoubleValue("PIXSCAL1", 0.0);
                        this.xinc = -secpix / 3600.0;
                        secpix = head.getDoubleValue("PIXSCAL2", 0.0);
                        this.yinc = secpix / 3600.0;
                    }
                } else {
                    this.yinc = secpix / 3600.0;
                    this.xinc = -this.yinc;
                }
                this.xrefpix = head.getDoubleValue("CRPIX1", this.nxpix * 0.5);
                this.yrefpix = head.getDoubleValue("CRPIX2", this.nypix * 0.5);
                this.xref = 0.0;
                this.xref = head.getDoubleValue("RA", 0.0);
                if (this.xref == 0.0) {
                    System.err.println("WCSINIT: No RA with SECPIX, no WCS");
                    throw new IllegalArgumentException(NO_WCS_IN_HEADER_MESSAGE);
                }
                this.yref = 0.0;
                this.yref = head.getDoubleValue("DEC", 0.0);
                if (this.yref == 0.0) {
                    System.err.println("WCSINIT: No DEC with SECPIX, no WCS");
                    throw new IllegalArgumentException(NO_WCS_IN_HEADER_MESSAGE);
                }
                this.c1type = "RA--TAN";
                this.c2type = "DEC-TAN";
                this.ptype = "-TAN";
                this.pcode = 1;
                this.coorflip = 0;
                this.degout = 0;
                this.ndec = 3;
                this.rot = head.getDoubleValue("CROTA1", 0.0);
                if (this.rot == 0.0) {
                    this.rot = head.getDoubleValue("CROTA2", 0.0);
                }
                this.cd11 = 0.0;
                this.cd21 = 0.0;
                this.cd12 = 0.0;
                this.cd22 = 0.0;
                this.dc11 = 0.0;
                this.dc21 = 0.0;
                this.dc12 = 0.0;
                this.dc22 = 0.0;
                this.rotmat = 0;
                this.xmpix = head.getDoubleValue("CCPIX1");
                this.ympix = head.getDoubleValue("CCPIX2");
                this.mrot = head.getDoubleValue("CCROT1");
                this.wcseq(head);
                this.epoch = head.getDoubleValue("DATE-OBS", 0.0);
                if (this.epoch == 0.0 && (this.epoch = head.getDoubleValue("EPOCH", 0.0)) == 0.0) {
                    this.epoch = this.equinox;
                }
                this.wcson = 1;
            } else {
                throw new IllegalArgumentException(NO_WCS_IN_HEADER_MESSAGE);
            }
        }
        this.sysout = this.radecsys;
        this.changesys = 0;
        this.printsys = 1;
        this.tabsys = 0;
        this.wcsfull();
    }

    public WCSTransform(double cra, double cdec, double xsecpix, double ysecpix, double xrpix, double yrpix, int nxpix, int nypix, double rotate, int equinox, double epoch, String proj) {
        this.nxpix = nxpix;
        this.nypix = nypix;
        this.xinc = xsecpix / 3600.0;
        this.yinc = ysecpix / 3600.0;
        this.xrefpix = xrpix;
        this.yrefpix = yrpix;
        this.xref = cra;
        this.yref = cdec;
        this.c1type = "RA-";
        this.c2type = "DEC";
        this.ptype = proj;
        this.pcode = 1;
        this.coorflip = 0;
        this.rot = rotate;
        this.rotmat = 0;
        this.cd11 = 0.0;
        this.cd21 = 0.0;
        this.cd12 = 0.0;
        this.cd22 = 0.0;
        this.dc11 = 0.0;
        this.dc21 = 0.0;
        this.dc12 = 0.0;
        this.dc22 = 0.0;
        this.equinox = equinox;
        this.radecsys = equinox > 1980 ? "FK5" : "FK4";
        this.epoch = epoch > 0.0 ? epoch : 0.0;
        this.wcson = 1;
        this.sysout = this.radecsys;
        this.changesys = 0;
        this.printsys = 1;
        this.tabsys = 0;
        this.pcode = 0;
        for (int i = 0; i < 8; ++i) {
            if (!this.ptype.startsWith(this.ctypes[i])) continue;
            this.pcode = i + 1;
        }
        this.wcsfull();
    }

    @Override
    public double getEquinox() {
        return this.equinox;
    }

    @Override
    public Point2D.Double getWCSCenter() {
        if (this.isValid()) {
            return new Point2D.Double(this.fCenterRa, this.fCenterDec);
        }
        throw new RuntimeException("No WCS information.");
    }

    @Override
    public Point2D.Double getImageCenter() {
        return new Point2D.Double(0.5 * this.nxpix, 0.5 * this.nypix);
    }

    @Override
    public boolean isWCS() {
        return this.isValid();
    }

    @Override
    public void imageToWorldCoords(Point2D.Double p, boolean isDistance) {
        if (!this.isValid()) {
            return;
        }
        if (isDistance) {
            p.x = Math.abs(p.x * this.degPerPixel.x);
            p.y = Math.abs(p.y * this.degPerPixel.y);
        } else {
            Point2D.Double r = this.pix2wcs(p.x, p.y);
            if (r != null) {
                p.setLocation(r.x, r.y);
            } else {
                throw new RuntimeException("Image coordinates out of WCS range: " + p);
            }
        }
    }

    @Override
    public void worldToImageCoords(Point2D.Double p, boolean isDistance) {
        if (!this.isValid()) {
            return;
        }
        if (isDistance) {
            p.x = Math.abs(p.x / this.degPerPixel.x);
            p.y = Math.abs(p.y / this.degPerPixel.y);
        } else {
            Point2D.Double r = this.wcs2pix(p.x, p.y);
            if (r != null) {
                p.setLocation(r.x, r.y);
            } else {
                throw new RuntimeException("World coordinates out of range: " + p);
            }
        }
    }

    @Override
    public double getWidthInDeg() {
        return this.fWidthDeg;
    }

    @Override
    public double getHeightInDeg() {
        return this.fHeightDeg;
    }

    @Override
    public double getWidth() {
        return this.nxpix;
    }

    @Override
    public double getHeight() {
        return this.nypix;
    }

    public void wcseq(WCSKeywordProvider head) {
        int ieq = 0;
        if (head.findKey("EQUINOX")) {
            this.equinox = head.getDoubleValue("EQUINOX");
            ieq = 2000;
        } else if (head.findKey("EPOCH")) {
            ieq = (int)head.getDoubleValue("EPOCH", 0.0);
            if (ieq == 0) {
                ieq = 1950;
                this.equinox = 1950.0;
            } else {
                this.equinox = head.getDoubleValue("EPOCH");
            }
        } else if (head.findKey("RADECSYS")) {
            String wcstemp = head.getStringValue("RADECSYS");
            if (wcstemp.startsWith("FK4")) {
                this.equinox = 1950.0;
                ieq = 1950;
            } else if (wcstemp.startsWith("FK5")) {
                this.equinox = 2000.0;
                ieq = 2000;
            } else if (wcstemp.startsWith("GAL")) {
                this.equinox = 2000.0;
                ieq = 2000;
            } else if (wcstemp.startsWith("ECL")) {
                this.equinox = 2000.0;
                ieq = 2000;
            }
        }
        if (ieq == 0) {
            this.equinox = 2000.0;
            ieq = 2000;
        }
        if ((this.epoch = head.getDoubleValue("DATE-OBS", 0.0)) == 0.0 && (this.epoch = head.getDoubleValue("EPOCH", 0.0)) == 0.0) {
            this.epoch = this.equinox;
        }
        if (this.epoch == 0.0) {
            this.epoch = this.equinox;
        }
        if (head.findKey("RADECSYS")) {
            if (this.radecsys.startsWith("FK4")) {
                this.equinox = 1950.0;
            } else if (this.radecsys.startsWith("FK5")) {
                this.equinox = 2000.0;
            } else if (this.radecsys.startsWith("GAL") && ieq == 0) {
                this.equinox = 2000.0;
            }
        } else {
            this.radecsys = this.c1type.charAt(0) == 'G' ? "GALACTIC" : (this.c1type.charAt(0) == 'E' ? "ECLIPTIC" : (this.c1type.charAt(0) == 'S' ? "SGALACTC" : (this.c1type.charAt(0) == 'H' ? "HELIOECL" : (this.c1type.charAt(0) == 'A' ? "ALTAZ" : (ieq > 1980 ? "FK5" : "FK4")))));
        }
    }

    public boolean isValid() {
        return this.wcson > 0;
    }

    public void wcsshift(double rra, double rdec, String coorsys) {
        if (!this.isValid()) {
            return;
        }
        this.fCenterRa = this.xref = rra;
        this.fCenterDec = this.yref = rdec;
        this.radecsys = coorsys;
        this.equinox = coorsys.startsWith("FK4") ? 1950.0 : 2000.0;
    }

    public void wcssize() {
        if (this.isValid()) {
            double xpix = 0.5 * this.nxpix;
            double ypix = 0.5 * this.nypix;
            Point2D.Double center = this.pix2wcs(xpix, ypix);
            if (center == null) {
                return;
            }
            this.fCenterRa = center.x;
            this.fCenterDec = center.y;
            Point2D.Double pos1 = this.pix2wcs(1.0, ypix);
            Point2D.Double pos2 = this.pix2wcs(this.nxpix, ypix);
            if (pos1 == null || pos2 == null) {
                return;
            }
            if (!this.ptype.startsWith("LINEAR") && !this.ptype.startsWith("PIXEL")) {
                double width = this.wcsdist(pos1.x, pos1.y, pos2.x, pos2.y);
                this.fHalfWidthRa = width * 0.5 / Math.cos(WCSTransform.degrad(this.fCenterDec));
            } else {
                this.fHalfWidthRa = Math.sqrt((pos2.y - pos1.y) * (pos2.y - pos1.y) + (pos2.x - pos1.x) * (pos2.x - pos1.x));
            }
            pos1 = this.pix2wcs(xpix, 1.0);
            pos2 = this.pix2wcs(xpix, this.nypix);
            if (pos1 == null || pos2 == null) {
                return;
            }
            if (!this.ptype.startsWith("LINEAR") && !this.ptype.startsWith("PIXEL")) {
                double height = this.wcsdist(pos1.x, pos1.y, pos2.x, pos2.y);
                this.fHalfWidthDec = height * 0.5;
            } else {
                this.fHalfWidthDec = Math.sqrt((pos2.y - pos1.y) * (pos2.y - pos1.y) + (pos2.x - pos1.x) * (pos2.x - pos1.x));
            }
        }
    }

    protected void wcsfull() {
        if (this.isValid()) {
            double xpix = 0.5 * this.nxpix;
            double ypix = 0.5 * this.nypix;
            Point2D.Double center = this.pix2wcs(xpix, ypix);
            if (center == null) {
                return;
            }
            this.fCenterRa = center.x;
            this.fCenterDec = center.y;
            Point2D.Double pos1 = this.pix2wcs(0.0, ypix);
            Point2D.Double pos2 = this.pix2wcs(this.nxpix, ypix);
            if (pos1 == null || pos2 == null) {
                return;
            }
            this.fWidthDeg = !this.ptype.startsWith("LINEAR") && !this.ptype.startsWith("PIXEL") ? this.wcsdist(pos1.x, pos1.y, pos2.x, pos2.y) : Math.sqrt((pos2.y - pos1.y) * (pos2.y - pos1.y) + (pos2.x - pos1.x) * (pos2.x - pos1.x));
            pos1 = this.pix2wcs(xpix, 0.0);
            pos2 = this.pix2wcs(xpix, this.nypix);
            if (pos1 == null || pos2 == null) {
                return;
            }
            this.fHeightDeg = !this.ptype.startsWith("LINEAR") && !this.ptype.startsWith("PIXEL") ? this.wcsdist(pos1.x, pos1.y, pos2.x, pos2.y) : Math.sqrt((pos2.y - pos1.y) * (pos2.y - pos1.y) + (pos2.x - pos1.x) * (pos2.x - pos1.x));
            this.degPerPixel = new Point2D.Double(this.fWidthDeg / this.nxpix, this.fHeightDeg / this.nypix);
        }
    }

    public double wcsdist(double x1, double y1, double x2, double y2) {
        double[] pos1 = new double[3];
        double[] pos2 = new double[3];
        double xr1 = WCSTransform.degrad(x1);
        double yr1 = WCSTransform.degrad(y1);
        double cosb = Math.cos(yr1);
        pos1[0] = Math.cos(xr1) * cosb;
        pos1[1] = Math.sin(xr1) * cosb;
        pos1[2] = Math.sin(yr1);
        double xr2 = WCSTransform.degrad(x2);
        double yr2 = WCSTransform.degrad(y2);
        cosb = Math.cos(yr2);
        pos2[0] = Math.cos(xr2) * cosb;
        pos2[1] = Math.sin(xr2) * cosb;
        pos2[2] = Math.sin(yr2);
        double w = 0.0;
        for (int i = 0; i < 3; ++i) {
            w += (pos1[i] - pos2[i]) * (pos1[i] - pos2[i]);
        }
        if ((w /= 4.0) > 1.0) {
            w = 1.0;
        }
        double diff = 2.0 * Math.atan2(Math.sqrt(w), Math.sqrt(1.0 - w));
        diff = WCSTransform.raddeg(diff);
        return diff;
    }

    public Point2D.Double pix2wcs(double xpix, double ypix) {
        Point2D.Double position;
        if (!this.isValid()) {
            return null;
        }
        this.xpix = xpix;
        this.ypix = ypix;
        this.offscl = 0;
        if (this.plate_fit > 0) {
            position = platepos.getPosition(xpix, ypix, this);
            if (position == null) {
                this.offscl = 1;
            }
        } else {
            position = worldpos.getPosition(xpix, ypix, this);
            if (position == null) {
                this.offscl = 1;
            }
        }
        if (this.pcode > 0) {
            if (this.radecsys.startsWith("FK4")) {
                if (this.equinox != 1950.0) {
                    position = wcscon.fk4prec(this.equinox, 1950.0, position);
                }
            } else if (this.radecsys.startsWith("FK5") && this.equinox != 2000.0) {
                position = wcscon.fk5prec(this.equinox, 2000.0, position);
            }
            if (this.changesys == 1) {
                position = wcscon.fk425e(position, this.epoch);
            } else if (this.changesys == 2) {
                position = wcscon.fk524e(position, this.epoch);
            } else if (this.changesys == 3) {
                position = wcscon.fk42gal(position);
            } else if (this.changesys == 4) {
                position = wcscon.fk52gal(position);
            }
        }
        if (this.offscl == 0 && position != null) {
            this.xpos = position.x;
            this.ypos = position.y;
        }
        return position;
    }

    public Point2D.Double wcs2pix(double xpos, double ypos) {
        Point2D.Double pixels;
        if (!this.isValid()) {
            return null;
        }
        this.xpos = xpos;
        this.ypos = ypos;
        Point2D.Double position = new Point2D.Double(xpos, ypos);
        if (this.changesys == 1) {
            position = wcscon.fk524e(position, this.epoch);
        } else if (this.changesys == 2) {
            position = wcscon.fk425e(position, this.epoch);
        }
        if (this.radecsys.startsWith("FK4")) {
            if (this.equinox != 1950.0) {
                position = wcscon.fk4prec(1950.0, this.equinox, position);
            }
        } else if (this.radecsys.startsWith("FK5") && this.equinox != 2000.0) {
            position = wcscon.fk5prec(2000.0, this.equinox, position);
        }
        if (this.plate_fit > 0) {
            pixels = platepos.getPixels(position.x, position.y, this);
            if (pixels == null) {
                this.offscl = 1;
            }
        } else {
            pixels = worldpos.getPixels(position.x, position.y, this);
            if (pixels == null) {
                this.offscl = 1;
            }
        }
        if (pixels != null) {
            this.xpix = pixels.x;
            this.ypix = pixels.y;
        }
        return pixels;
    }

    public double getXArcsecPerPix() {
        return this.xinc * 3600.0;
    }
}

