/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.converter;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.opencds.cqf.cql.engine.fhir.converter.Dstu2FhirTypeConverter;
import org.opencds.cqf.cql.engine.fhir.converter.Dstu3FhirTypeConverter;
import org.opencds.cqf.cql.engine.fhir.converter.FhirTypeConverter;
import org.opencds.cqf.cql.engine.fhir.converter.R4FhirTypeConverter;
import org.opencds.cqf.cql.engine.fhir.converter.R5FhirTypeConverter;

public class FhirTypeConverterFactory {
    public FhirTypeConverter create(FhirVersionEnum fhirVersionEnum) {
        switch (fhirVersionEnum) {
            case DSTU2_HL7ORG: {
                return new Dstu2FhirTypeConverter();
            }
            case DSTU3: {
                return new Dstu3FhirTypeConverter();
            }
            case R4: {
                return new R4FhirTypeConverter();
            }
            case R5: {
                return new R5FhirTypeConverter();
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported FHIR version for type conversion: %s", fhirVersionEnum));
    }
}

