/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.model;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.util.Arrays;
import java.util.Calendar;
import org.hl7.fhir.dstu3.model.Age;
import org.hl7.fhir.dstu3.model.AnnotatedUuidType;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BaseDateTimeType;
import org.hl7.fhir.dstu3.model.Count;
import org.hl7.fhir.dstu3.model.Distance;
import org.hl7.fhir.dstu3.model.Duration;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.OidType;
import org.hl7.fhir.dstu3.model.PositiveIntType;
import org.hl7.fhir.dstu3.model.Quantity;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.SimpleQuantity;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.TimeType;
import org.hl7.fhir.dstu3.model.UnsignedIntType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UuidType;
import org.opencds.cqf.cql.engine.exception.InvalidCast;
import org.opencds.cqf.cql.engine.fhir.model.FhirModelResolver;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;

public class Dstu3FhirModelResolver
extends FhirModelResolver<Base, BaseDateTimeType, TimeType, SimpleQuantity, IdType, Resource, Enumeration<?>, EnumFactory<?>> {
    public Dstu3FhirModelResolver() {
        this(FhirContext.forDstu3());
    }

    private Dstu3FhirModelResolver(FhirContext fhirContext) {
        super(fhirContext);
        this.setPackageNames(Arrays.asList("org.hl7.fhir.dstu3.model"));
        if (fhirContext.getVersion().getVersion() != FhirVersionEnum.DSTU3) {
            throw new IllegalArgumentException("The supplied context is not configured for DSTU3");
        }
    }

    @Override
    protected void initialize() {
        this.fhirContext.registerCustomType(AnnotatedUuidType.class);
        block3: for (Enumerations.ResourceType type : Enumerations.ResourceType.values()) {
            switch (type) {
                case DOMAINRESOURCE: 
                case RESOURCE: 
                case NULL: {
                    continue block3;
                }
                default: {
                    this.fhirContext.getResourceDefinition(type.toCode());
                }
            }
        }
    }

    @Override
    protected Boolean equalsDeep(Base left, Base right) {
        return left.equalsDeep(right);
    }

    @Override
    protected SimpleQuantity castToSimpleQuantity(Base base) {
        return base.castToSimpleQuantity(base);
    }

    @Override
    protected Calendar getCalendar(BaseDateTimeType dateTime) {
        return dateTime.getValueAsCalendar();
    }

    @Override
    protected Integer getCalendarConstant(BaseDateTimeType dateTime) {
        return dateTime.getPrecision().getCalendarConstant();
    }

    @Override
    protected void setCalendarConstant(BaseDateTimeType dateTime, BaseTemporal temporal) {
        dateTime.setPrecision(this.toTemporalPrecisionEnum(temporal.getPrecision()));
    }

    @Override
    protected String timeToString(TimeType time) {
        return (String)time.getValue();
    }

    @Override
    protected String idToString(IdType id) {
        return id.getIdPart();
    }

    @Override
    protected String getResourceType(Resource resource) {
        return resource.fhirType();
    }

    @Override
    protected Enumeration<?> enumConstructor(EnumFactory<?> factory) {
        return new Enumeration(factory);
    }

    @Override
    protected Boolean enumChecker(Object object) {
        return object instanceof Enumeration;
    }

    @Override
    protected Class<?> enumFactoryTypeGetter(Enumeration<?> enumeration) {
        return enumeration.getEnumFactory().getClass();
    }

    @Override
    public Class<?> resolveType(String typeName) {
        switch (typeName) {
            case "ConfidentialityClassification": {
                typeName = "Composition$DocumentConfidentiality";
                break;
            }
            case "ContractResourceStatusCodes": {
                typeName = "Contract$ContractStatus";
                break;
            }
            case "EventStatus": {
                typeName = "Procedure$ProcedureStatus";
                break;
            }
            case "qualityType": {
                typeName = "Sequence$QualityType";
                break;
            }
            case "FinancialResourceStatusCodes": {
                typeName = "ClaimResponse$ClaimResponseStatus";
                break;
            }
            case "repositoryType": {
                typeName = "Sequence$RepositoryType";
                break;
            }
            case "SampledDataDataType": {
                typeName = "StringType";
            }
        }
        return super.resolveType(typeName);
    }

    public Boolean is(Object value, Class<?> type) {
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return true;
        }
        if (value instanceof UriType) {
            switch (type.getSimpleName()) {
                case "UrlType": {
                    return true;
                }
                case "CanonicalType": {
                    return true;
                }
                case "AnnotatedUuidType": 
                case "UuidType": {
                    return true;
                }
                case "OidType": {
                    return true;
                }
            }
        }
        if (value instanceof IntegerType) {
            switch (type.getSimpleName()) {
                case "PositiveIntType": {
                    return true;
                }
                case "UnsignedIntType": {
                    return true;
                }
            }
        }
        if (value instanceof StringType) {
            switch (type.getSimpleName()) {
                case "CodeType": {
                    return true;
                }
                case "MarkdownType": {
                    return true;
                }
                case "IdType": {
                    return true;
                }
            }
        }
        if (value instanceof Quantity) {
            switch (type.getSimpleName()) {
                case "Age": 
                case "Distance": 
                case "Duration": 
                case "Count": 
                case "SimpleQuantity": 
                case "MoneyQuantity": {
                    return true;
                }
            }
        }
        return false;
    }

    public Object as(Object value, Class<?> type, boolean isStrict) {
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return value;
        }
        if (value instanceof UriType) {
            UriType uriType = (UriType)value;
            switch (type.getSimpleName()) {
                case "AnnotatedUuidType": 
                case "UuidType": {
                    return uriType.hasPrimitiveValue() && ((String)uriType.getValue()).startsWith("urn:uuid:") ? new UuidType(uriType.primitiveValue()) : null;
                }
                case "OidType": {
                    return uriType.hasPrimitiveValue() && ((String)uriType.getValue()).startsWith("urn:oid:") ? new OidType(uriType.primitiveValue()) : null;
                }
            }
        }
        if (value instanceof IntegerType) {
            IntegerType integerType = (IntegerType)value;
            switch (type.getSimpleName()) {
                case "PositiveIntType": {
                    return integerType.hasPrimitiveValue() && (Integer)integerType.getValue() > 0 ? new PositiveIntType(integerType.primitiveValue()) : null;
                }
                case "UnsignedIntType": {
                    return integerType.hasPrimitiveValue() && (Integer)integerType.getValue() >= 0 ? new UnsignedIntType(integerType.primitiveValue()) : null;
                }
            }
        }
        if (value instanceof StringType) {
            StringType stringType = (StringType)value;
            switch (type.getSimpleName()) {
                case "CodeType": {
                    return stringType.castToCode((Base)stringType);
                }
                case "MarkdownType": {
                    return stringType.castToMarkdown((Base)stringType);
                }
                case "IdType": {
                    return stringType.hasPrimitiveValue() ? new IdType(stringType.primitiveValue()) : null;
                }
            }
        }
        if (value instanceof Quantity) {
            Quantity quantity = (Quantity)value;
            switch (type.getSimpleName()) {
                case "Age": {
                    Age age = new Age();
                    age.setValue(quantity.getValue());
                    age.setCode(quantity.getCode());
                    return age;
                }
                case "Distance": {
                    Distance distance = new Distance();
                    distance.setValue(quantity.getValue());
                    distance.setCode(quantity.getCode());
                    return distance;
                }
                case "Duration": {
                    Duration duration = new Duration();
                    duration.setValue(quantity.getValue());
                    duration.setCode(quantity.getCode());
                    return duration;
                }
                case "Count": {
                    Count count = new Count();
                    count.setValue(quantity.getValue());
                    count.setCode(quantity.getCode());
                    return count;
                }
                case "SimpleQuantity": {
                    return quantity.castToSimpleQuantity((Base)quantity);
                }
            }
        }
        if (isStrict) {
            throw new InvalidCast(String.format("Cannot cast a value of type %s as %s.", value.getClass().getName(), type.getName()));
        }
        return null;
    }

    @Override
    public Object getContextPath(String contextType, String targetType) {
        if (targetType == null || contextType == null) {
            return null;
        }
        if (contextType != null && !contextType.equals("Unspecified") && !contextType.equals("Population") && contextType.equals("Patient") && targetType.equals("MedicationStatement")) {
            return "subject";
        }
        return super.getContextPath(contextType, targetType);
    }
}

