/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.searchparam;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeSearchParam;
import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import ca.uhn.fhir.rest.param.NumberParam;
import ca.uhn.fhir.rest.param.QuantityParam;
import ca.uhn.fhir.rest.param.ReferenceParam;
import ca.uhn.fhir.rest.param.StringParam;
import ca.uhn.fhir.rest.param.TokenParam;
import ca.uhn.fhir.rest.param.UriParam;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;

public class SearchParameterResolver {
    private FhirContext context;

    public SearchParameterResolver(FhirContext context) {
        this.context = context;
    }

    public RuntimeSearchParam getSearchParameterDefinition(String dataType, String path) {
        return this.getSearchParameterDefinition(dataType, path, null);
    }

    public RuntimeSearchParam getSearchParameterDefinition(String dataType, String path, RestSearchParameterTypeEnum paramType) {
        if (dataType == null || path == null) {
            return null;
        }
        String name = null;
        if (path.equals("id")) {
            name = "_id";
            path = "";
        }
        List params = this.context.getResourceDefinition(dataType).getSearchParams();
        for (RuntimeSearchParam param : params) {
            String normalizedPath;
            if (name != null && param.getName().equals(name)) {
                return param;
            }
            if (paramType != null && !param.getParamType().equals((Object)paramType) || !path.equals(normalizedPath = this.normalizePath(param.getPath()))) continue;
            return param;
        }
        return null;
    }

    public Pair<String, IQueryParameterType> createSearchParameter(String context, String dataType, String path, String value) {
        RuntimeSearchParam searchParam = this.getSearchParameterDefinition(dataType, path);
        if (searchParam == null) {
            return null;
        }
        String name = searchParam.getName();
        switch (searchParam.getParamType()) {
            case TOKEN: {
                return Pair.of((Object)name, (Object)new TokenParam(value));
            }
            case REFERENCE: {
                return Pair.of((Object)name, (Object)new ReferenceParam(context, null, value));
            }
            case QUANTITY: {
                return Pair.of((Object)name, (Object)new QuantityParam(value));
            }
            case STRING: {
                return Pair.of((Object)name, (Object)new StringParam(value));
            }
            case NUMBER: {
                return Pair.of((Object)name, (Object)new NumberParam(value));
            }
            case URI: {
                return Pair.of((Object)name, (Object)new UriParam(value));
            }
        }
        return null;
    }

    private String normalizePath(String path) {
        String[] orParts;
        if (path.equals("(")) {
            path = path.substring(1, path.length() - 1);
        }
        HashSet<String> normalizedParts = new HashSet<String>();
        for (String part : orParts = path.split("\\|")) {
            path = part.trim();
            path = path.substring(path.indexOf(".") + 1, path.length());
            String[] pathSplit = path.split("\\.");
            ArrayList<String> newPathParts = new ArrayList<String>();
            for (String p : pathSplit) {
                String[] ps;
                if (p.startsWith("as(") || p.startsWith("[x]") || (ps = p.split(" ")) == null || ps.length <= 0) continue;
                newPathParts.add(ps[0]);
            }
            path = String.join((CharSequence)".", newPathParts);
            normalizedParts.add(path);
        }
        if (normalizedParts.size() == 1) {
            return (String)normalizedParts.iterator().next();
        }
        return null;
    }
}

