/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.retrieve;

import ca.uhn.fhir.context.FhirVersionEnum;
import org.opencds.cqf.cql.engine.fhir.exception.FhirVersionMisMatchException;
import org.opencds.cqf.cql.engine.fhir.retrieve.BaseFhirQueryGenerator;
import org.opencds.cqf.cql.engine.fhir.retrieve.Dstu3FhirQueryGenerator;
import org.opencds.cqf.cql.engine.fhir.retrieve.R4FhirQueryGenerator;
import org.opencds.cqf.cql.engine.fhir.searchparam.SearchParameterResolver;
import org.opencds.cqf.cql.engine.model.ModelResolver;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;

public class FhirQueryGeneratorFactory {
    public static BaseFhirQueryGenerator create(ModelResolver modelResolver, SearchParameterResolver searchParameterResolver, TerminologyProvider terminologyProvider) throws FhirVersionMisMatchException {
        FhirVersionEnum fhirVersionEnum = searchParameterResolver.getFhirContext().getVersion().getVersion();
        if (fhirVersionEnum == FhirVersionEnum.DSTU3) {
            return new Dstu3FhirQueryGenerator(searchParameterResolver, terminologyProvider, modelResolver);
        }
        if (fhirVersionEnum == FhirVersionEnum.R4) {
            return new R4FhirQueryGenerator(searchParameterResolver, terminologyProvider, modelResolver);
        }
        throw new IllegalArgumentException(String.format("Unsupported FHIR version for FHIR Query Generation: %s", fhirVersionEnum));
    }

    public static BaseFhirQueryGenerator create(ModelResolver modelResolver, SearchParameterResolver searchParameterResolver, TerminologyProvider terminologyProvider, Boolean shouldExpandValueSets, Integer maxCodesPerQuery, Integer pageSize) throws FhirVersionMisMatchException {
        BaseFhirQueryGenerator baseFhirQueryGenerator = FhirQueryGeneratorFactory.create(modelResolver, searchParameterResolver, terminologyProvider);
        if (shouldExpandValueSets != null) {
            baseFhirQueryGenerator.setExpandValueSets(shouldExpandValueSets);
        }
        if (maxCodesPerQuery != null) {
            baseFhirQueryGenerator.setMaxCodesPerQuery(maxCodesPerQuery);
        }
        if (pageSize != null) {
            baseFhirQueryGenerator.setPageSize(pageSize);
        }
        return baseFhirQueryGenerator;
    }
}

