/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.terminology;

import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.gclient.IOperationUnnamed;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.CodeType;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.ValueSet;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.terminology.CodeSystemInfo;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;
import org.opencds.cqf.cql.engine.terminology.ValueSetInfo;

public class R4FhirTerminologyProvider
implements TerminologyProvider {
    private static final String URN_UUID = "urn:uuid:";
    private static final String URN_OID = "urn:oid:";
    private IGenericClient fhirClient;

    public R4FhirTerminologyProvider() {
    }

    public R4FhirTerminologyProvider(IGenericClient fhirClient) {
        this.fhirClient = fhirClient;
    }

    public IGenericClient getFhirClient() {
        return this.fhirClient;
    }

    public boolean in(Code code, ValueSetInfo valueSet) throws ResourceNotFoundException {
        if (this.resolveByUrl(valueSet) == null) {
            return false;
        }
        Parameters respParam = code.getSystem() != null ? (Parameters)((IOperationUnnamed)this.fhirClient.operation().onInstance((IIdType)new IdType("ValueSet", valueSet.getId()))).named("validate-code").withParameter(Parameters.class, "code", (IBase)new StringType(code.getCode())).andParameter("system", (IBase)new StringType(code.getSystem())).useHttpGet().execute() : (Parameters)((IOperationUnnamed)this.fhirClient.operation().onInstance((IIdType)new IdType("ValueSet", valueSet.getId()))).named("validate-code").withParameter(Parameters.class, "code", (IBase)new StringType(code.getCode())).useHttpGet().execute();
        return ((BooleanType)((Parameters.ParametersParameterComponent)respParam.getParameter().get(0)).getValue()).booleanValue();
    }

    public Iterable<Code> expand(ValueSetInfo valueSet) throws ResourceNotFoundException {
        if (this.resolveByUrl(valueSet) == null) {
            return Collections.emptyList();
        }
        Parameters respParam = (Parameters)((IOperationUnnamed)this.fhirClient.operation().onInstance((IIdType)new IdType("ValueSet", valueSet.getId()))).named("expand").withNoParameters(Parameters.class).useHttpGet().execute();
        ValueSet expanded = (ValueSet)((Parameters.ParametersParameterComponent)respParam.getParameter().get(0)).getResource();
        ArrayList<Code> codes = new ArrayList<Code>();
        for (ValueSet.ValueSetExpansionContainsComponent codeInfo : expanded.getExpansion().getContains()) {
            Code nextCode = new Code().withCode(codeInfo.getCode()).withSystem(codeInfo.getSystem()).withVersion(codeInfo.getVersion()).withDisplay(codeInfo.getDisplay());
            codes.add(nextCode);
        }
        return codes;
    }

    public Code lookup(Code code, CodeSystemInfo codeSystem) throws ResourceNotFoundException {
        Parameters respParam = (Parameters)((IOperationUnnamed)this.fhirClient.operation().onType(CodeSystem.class)).named("lookup").withParameter(Parameters.class, "code", (IBase)new CodeType(code.getCode())).andParameter("system", (IBase)new UriType(codeSystem.getId())).execute();
        StringType display = (StringType)respParam.getParameter("display");
        if (display != null) {
            code.withDisplay((String)display.getValue());
        }
        return code.withSystem(codeSystem.getId());
    }

    public Boolean resolveByUrl(ValueSetInfo valueSet) {
        if (valueSet.getVersion() != null || valueSet.getCodeSystems() != null && valueSet.getCodeSystems().size() > 0) {
            throw new UnsupportedOperationException(String.format("Could not expand value set %s; version and code system bindings are not supported at this time.", valueSet.getId()));
        }
        Bundle searchResults = (Bundle)this.fhirClient.search().forResource(ValueSet.class).where(ValueSet.URL.matches().value(valueSet.getId())).returnBundle(Bundle.class).execute();
        if (!searchResults.hasEntry() && !(searchResults = (Bundle)this.fhirClient.search().forResource(ValueSet.class).where(ValueSet.IDENTIFIER.exactly().code(valueSet.getId())).returnBundle(Bundle.class).execute()).hasEntry()) {
            String id = valueSet.getId();
            if (id.startsWith(URN_OID)) {
                id = id.replace(URN_OID, "");
            } else if (id.startsWith(URN_UUID)) {
                id = id.replace(URN_UUID, "");
            }
            searchResults = new Bundle();
            if (id.matches("[A-Za-z0-9\\-\\.]{1,64}")) {
                try {
                    ValueSet vs = (ValueSet)this.fhirClient.read().resource(ValueSet.class).withId(id).execute();
                    searchResults.addEntry().setResource((Resource)vs);
                }
                catch (ResourceNotFoundException resourceNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (!searchResults.hasEntry()) {
            throw new IllegalArgumentException(String.format("Could not resolve value set %s.", valueSet.getId()));
        }
        if (searchResults.getEntry().size() != 1) {
            throw new IllegalArgumentException("Found more than 1 ValueSet with url: " + valueSet.getId());
        }
        valueSet.setId(searchResults.getEntryFirstRep().getResource().getIdElement().getIdPart());
        return true;
    }
}

