/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.fhir.retrieve;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.util.BundleUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.opencds.cqf.cql.engine.fhir.exception.UnknownElement;

public class FhirBundleCursor
implements Iterable<Object> {
    private IGenericClient fhirClient;
    private IBaseBundle results;
    private String dataType;
    private String templateId;

    public FhirBundleCursor(IGenericClient fhirClient, IBaseBundle results) {
        this(fhirClient, results, null, null);
    }

    public FhirBundleCursor(IGenericClient fhirClient, IBaseBundle results, String dataType) {
        this(fhirClient, results, null, null);
    }

    public FhirBundleCursor(IGenericClient fhirClient, IBaseBundle results, String dataType, String templateId) {
        this.fhirClient = fhirClient;
        this.results = results;
        this.dataType = dataType;
        this.templateId = templateId;
    }

    @Override
    public Iterator<Object> iterator() {
        return new FhirBundleIterator(this.fhirClient, this.results, this.dataType, this.templateId);
    }

    private class FhirBundleIterator
    implements Iterator<Object> {
        private IGenericClient fhirClient;
        private IBaseBundle results;
        private int current;
        private String dataType;
        private String templateId;
        private Class<? extends IBaseResource> dataTypeClass;
        private List<? extends IBaseResource> currentEntry;

        public FhirBundleIterator(IGenericClient fhirClient, IBaseBundle results, String dataType, String templateId) {
            this.fhirClient = fhirClient;
            this.results = results;
            this.current = -1;
            this.dataType = dataType;
            this.templateId = templateId;
            if (this.templateId != null && this.templateId.startsWith(String.format("http://hl7.org/fhir/StructureDefinition/%s", dataType))) {
                this.templateId = null;
            }
            if (dataType != null) {
                this.dataTypeClass = this.fhirClient.getFhirContext().getResourceDefinition(this.dataType).getImplementingClass();
            }
            this.currentEntry = this.getEntry();
        }

        @Override
        public boolean hasNext() {
            return this.current < this.currentEntry.size() - 1 || this.getLink() != null;
        }

        private List<? extends IBaseResource> getEntry() {
            if (this.dataTypeClass != null) {
                List entries = BundleUtil.toListOfResourcesOfType((FhirContext)this.fhirClient.getFhirContext(), (IBaseBundle)this.results, this.dataTypeClass);
                if (this.templateId != null) {
                    return this.getTrustedEntries(entries, this.templateId);
                }
                return entries;
            }
            return BundleUtil.toListOfResources((FhirContext)this.fhirClient.getFhirContext(), (IBaseBundle)this.results);
        }

        private List<? extends IBaseResource> getTrustedEntries(List<? extends IBaseResource> entries, String templateId) {
            ArrayList<IBaseResource> trustedEntries = new ArrayList<IBaseResource>();
            for (IBaseResource iBaseResource : entries) {
                if (iBaseResource.getMeta() == null || iBaseResource.getMeta().getProfile() == null) continue;
                for (IPrimitiveType profile : iBaseResource.getMeta().getProfile()) {
                    if (!profile.hasValue() || !profile.getValueAsString().equals(templateId)) continue;
                    trustedEntries.add(iBaseResource);
                }
            }
            return trustedEntries;
        }

        private String getLink() {
            return BundleUtil.getLinkUrlOfType((FhirContext)this.fhirClient.getFhirContext(), (IBaseBundle)this.results, (String)"next");
        }

        @Override
        public Object next() {
            ++this.current;
            if (this.current < this.currentEntry.size()) {
                return this.currentEntry.get(this.current);
            }
            this.results = (IBaseBundle)this.fhirClient.loadPage().next(this.results).execute();
            this.currentEntry = this.getEntry();
            this.current = 0;
            if (this.current < this.currentEntry.size()) {
                return this.currentEntry.get(this.current);
            }
            throw new UnknownElement("The iteration has no more elements.");
        }
    }
}

