/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.serializing.jackson.modules;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import java.io.IOException;
import javax.xml.namespace.QName;

public class QNameFixerXMLMapperDeserializer
extends JsonDeserializer<QName> {
    JsonDeserializer<?> originalDeserializer;

    public QNameFixerXMLMapperDeserializer(JsonDeserializer<?> deserializer) {
        this.originalDeserializer = deserializer;
    }

    public QName deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        QName qName = (QName)this.originalDeserializer.deserialize(jsonParser, deserializationContext);
        if (qName.getLocalPart().indexOf(":") > 0) {
            String prefix = qName.getLocalPart().split(":")[0];
            String localPart = qName.getLocalPart().split(":")[1];
            String namespace = ((FromXmlParser)deserializationContext.getParser()).getStaxReader().getNamespaceContext().getNamespaceURI(prefix);
            return new QName(namespace, localPart, prefix);
        }
        return qName;
    }
}

