/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.Log;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Value;

public class LogEvaluator
extends Log {
    public static Object log(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof BigDecimal) {
            Double base = Math.log(((BigDecimal)right).doubleValue());
            Double value = Math.log(((BigDecimal)left).doubleValue());
            if (base == 0.0) {
                return Value.verifyPrecision(new BigDecimal(value), null);
            }
            return Value.verifyPrecision(new BigDecimal(value / base), null);
        }
        throw new InvalidOperatorArgument("Log(Decimal, Decimal)", String.format("Log(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        return LogEvaluator.log(left, right);
    }
}

