/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.debug;

import org.opencds.cqf.cql.engine.debug.Location;

public class DebugLocator {
    private final DebugLocatorType type;
    private final String locator;
    private final Location location;

    public DebugLocatorType getLocatorType() {
        return this.type;
    }

    public String getLocator() {
        return this.locator;
    }

    public Location getLocation() {
        return this.location;
    }

    public DebugLocator(Location location) {
        this.type = DebugLocatorType.LOCATION;
        this.locator = location.toLocator();
        this.location = location;
    }

    private void guardLocator(String locator) {
        if (locator == null || locator.trim().isEmpty()) {
            throw new IllegalArgumentException("nodeId locator required");
        }
    }

    public DebugLocator(DebugLocatorType type, String locator) {
        this.type = type;
        switch (type) {
            case NODE_ID: 
            case EXCEPTION_TYPE: {
                this.guardLocator(locator);
                this.locator = locator;
                this.location = null;
                break;
            }
            case NODE_TYPE: {
                this.guardLocator(locator);
                this.locator = !locator.endsWith("Evaluator") ? String.valueOf(locator) + "Evaluator" : locator;
                this.location = null;
                break;
            }
            case LOCATION: {
                this.location = Location.fromLocator(locator);
                this.locator = locator;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown debug locator type: %s", type.toString()));
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DebugLocator other = (DebugLocator)o;
        if (this.type != other.type) {
            return false;
        }
        return this.locator == other.locator;
    }

    public int hashCode() {
        int result = this.locator.hashCode();
        result = 31 * result + this.type.ordinal();
        return result;
    }

    public String toString() {
        return "DebugLocator{ type=" + this.type.toString() + ", locator=" + this.locator + '}';
    }

    public static enum DebugLocatorType {
        NODE_ID,
        NODE_TYPE,
        LOCATION,
        EXCEPTION_TYPE;

    }
}

