/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.debug;

public class Location {
    private final int startLine;
    private final int startChar;
    private final int endLine;
    private final int endChar;

    public Location(int startLine, int startChar, int endLine, int endChar) {
        this.startLine = startLine;
        this.startChar = startChar;
        this.endLine = endLine;
        this.endChar = endChar;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartChar() {
        return this.startChar;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndChar() {
        return this.endChar;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location other = (Location)o;
        if (this.endChar != other.endChar) {
            return false;
        }
        if (this.endLine != other.endLine) {
            return false;
        }
        if (this.startChar != other.startChar) {
            return false;
        }
        return this.startLine == other.startLine;
    }

    public boolean includes(Location other) {
        if (other == null) {
            throw new IllegalArgumentException("other required");
        }
        if (this.startLine > other.startLine) {
            return false;
        }
        if (this.startLine == other.startLine && this.startChar > other.startChar) {
            return false;
        }
        if (this.endLine < other.endLine) {
            return false;
        }
        return this.endLine != other.endLine || this.endChar >= other.endChar;
    }

    public int hashCode() {
        int result = 13;
        result = 31 * result + this.startLine;
        result = 31 * result + this.startChar;
        result = 31 * result + this.endLine;
        result = 31 * result + this.endChar;
        return result;
    }

    public String toString() {
        return "Location{ startLine=" + this.startLine + ", startChar=" + this.startChar + ", endLine=" + this.endLine + ", endChar=" + this.endChar + '}';
    }

    public String toLocator() {
        return this.startLine == this.endLine && this.startChar == this.endChar ? String.format("%s:%s", this.startLine, this.startChar) : String.format("%s:%s-%s:%s", this.startLine, this.startChar, this.endLine, this.endChar);
    }

    public static Location fromLocator(String locator) {
        if (locator == null || locator.trim().isEmpty()) {
            throw new IllegalArgumentException("locator required");
        }
        int startLine = 0;
        int startChar = 0;
        int endLine = 0;
        int endChar = 0;
        String[] locations = locator.split("-");
        int i = 0;
        while (i < locations.length) {
            String[] ranges = locations[i].split(":");
            if (ranges.length != 2) {
                throw new IllegalArgumentException(String.format("Invalid locator format: %s", locator));
            }
            if (i == 0) {
                startLine = Integer.parseInt(ranges[0]);
                startChar = Integer.parseInt(ranges[1]);
            } else {
                endLine = Integer.parseInt(ranges[0]);
                endChar = Integer.parseInt(ranges[1]);
            }
            ++i;
        }
        if (locations.length == 1) {
            endLine = startLine;
            endChar = startChar;
        }
        return new Location(startLine, startChar, endLine, endChar);
    }
}

