/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.util.ArrayList;
import java.util.Optional;
import org.cqframework.cql.elm.execution.Expression;
import org.cqframework.cql.elm.execution.FunctionDef;
import org.cqframework.cql.elm.execution.FunctionRef;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.execution.Variable;

public class FunctionRefEvaluator
extends FunctionRef {
    @Override
    protected Object internalEvaluate(Context context) {
        ArrayList<Object> arguments = new ArrayList<Object>();
        for (Expression operand : this.getOperand()) {
            arguments.add(operand.evaluate(context));
        }
        boolean enteredLibrary = context.enterLibrary(this.getLibraryName());
        try {
            FunctionDef functionDef = context.resolveFunctionRef(this.getName(), arguments, this.getLibraryName());
            if (Optional.ofNullable(functionDef.isExternal()).orElse(false).booleanValue()) {
                Object object = context.getExternalFunctionProvider().evaluate(functionDef.getName(), arguments);
                return object;
            }
            context.pushWindow();
            try {
                int i = 0;
                while (i < arguments.size()) {
                    context.push(new Variable().withName(functionDef.getOperand().get(i).getName()).withValue(arguments.get(i)));
                    ++i;
                }
                Object object = functionDef.getExpression().evaluate(context);
                context.popWindow();
                return object;
            }
            catch (Throwable throwable) {
                context.popWindow();
                throw throwable;
            }
        }
        finally {
            context.exitLibrary(enteredLibrary);
        }
    }
}

