/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.CodeSystemDef;
import org.cqframework.cql.elm.execution.CodeSystemRef;
import org.cqframework.cql.elm.execution.InCodeSystem;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Concept;
import org.opencds.cqf.cql.engine.terminology.CodeSystemInfo;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;

public class InCodeSystemEvaluator
extends InCodeSystem {
    public Object inCodeSystem(Context context, Object code, Object codeSystem) {
        if (code == null) {
            return null;
        }
        CodeSystemDef csd = this.resolveCSR(context, (CodeSystemRef)codeSystem);
        CodeSystemInfo csi = new CodeSystemInfo().withId(csd.getId()).withVersion(csd.getVersion());
        TerminologyProvider provider = context.resolveTerminologyProvider();
        if (code instanceof String) {
            if (provider.lookup(new Code().withCode((String)code), csi) != null) {
                return true;
            }
            return false;
        }
        if (code instanceof Code) {
            if (provider.lookup((Code)code, csi) != null) {
                return true;
            }
            return false;
        }
        if (code instanceof Concept) {
            for (Code codes : ((Concept)code).getCodes()) {
                if (provider.lookup(codes, csi) == null) continue;
                return true;
            }
            return false;
        }
        throw new InvalidOperatorArgument("In(String, CodeSystemRef), In(Code, CodeSystemRef) or In(Concept, CodeSystemRef)", String.format("In(%s, %s)", code.getClass().getName(), codeSystem.getClass().getName()));
    }

    public CodeSystemDef resolveCSR(Context context, CodeSystemRef codesystem) {
        return context.resolveCodeSystemRef(codesystem.getLibraryName(), codesystem.getName());
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object code = this.getCode().evaluate(context);
        CodeSystemRef codeSystem = this.getCodesystem();
        return this.inCodeSystem(context, code, codeSystem);
    }
}

