/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.cqframework.cql.elm.execution.AliasedQuerySource;
import org.cqframework.cql.elm.execution.ByColumn;
import org.cqframework.cql.elm.execution.ByExpression;
import org.cqframework.cql.elm.execution.Expression;
import org.cqframework.cql.elm.execution.LetClause;
import org.cqframework.cql.elm.execution.Query;
import org.cqframework.cql.elm.execution.RelationshipClause;
import org.cqframework.cql.elm.execution.SortByItem;
import org.cqframework.cql.elm.execution.SortClause;
import org.cqframework.cql.elm.execution.With;
import org.cqframework.cql.elm.execution.Without;
import org.opencds.cqf.cql.engine.elm.execution.DistinctEvaluator;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.execution.Variable;
import org.opencds.cqf.cql.engine.runtime.CqlList;
import org.opencds.cqf.cql.engine.runtime.Tuple;
import org.opencds.cqf.cql.engine.runtime.iterators.QueryIterator;

public class QueryEvaluator
extends Query {
    public Iterable<Object> ensureIterable(Object source) {
        if (source instanceof Iterable) {
            return (Iterable)source;
        }
        ArrayList<Object> sourceList = new ArrayList<Object>();
        if (source != null) {
            sourceList.add(source);
        }
        return sourceList;
    }

    private void evaluateLets(Context context, List<Variable> letVariables) {
        int i = 0;
        while (i < this.getLet().size()) {
            letVariables.get(i).setValue(this.getLet().get(i).getExpression().evaluate(context));
            ++i;
        }
    }

    private boolean evaluateRelationships(Context context) {
        boolean shouldInclude = true;
        for (RelationshipClause relationship : this.getRelationship()) {
            boolean hasSatisfyingData = false;
            Iterable<Object> relatedSourceData = this.ensureIterable(relationship.getExpression().evaluate(context));
            for (Object relatedElement : relatedSourceData) {
                context.push(new Variable().withName(relationship.getAlias()).withValue(relatedElement));
                try {
                    Object satisfiesRelatedCondition = relationship.getSuchThat().evaluate(context);
                    if (!(relationship instanceof With) && !(relationship instanceof Without) || !(satisfiesRelatedCondition instanceof Boolean) || !((Boolean)satisfiesRelatedCondition).booleanValue()) continue;
                    hasSatisfyingData = true;
                    break;
                }
                finally {
                    context.pop();
                }
            }
            if ((!(relationship instanceof With) || hasSatisfyingData) && (!(relationship instanceof Without) || !hasSatisfyingData)) continue;
            shouldInclude = false;
            break;
        }
        return shouldInclude;
    }

    private boolean evaluateWhere(Context context) {
        Object satisfiesCondition;
        return this.getWhere() == null || (satisfiesCondition = this.getWhere().evaluate(context)) instanceof Boolean && (Boolean)satisfiesCondition != false;
    }

    private Object evaluateReturn(Context context, List<Variable> variables, List<Object> elements) {
        return this.getReturn() != null ? this.getReturn().getExpression().evaluate(context) : this.constructResult(variables, elements);
    }

    private Object constructResult(List<Variable> variables, List<Object> elements) {
        if (variables.size() > 1) {
            LinkedHashMap<String, Object> elementMap = new LinkedHashMap<String, Object>();
            int i = 0;
            while (i < variables.size()) {
                elementMap.put(variables.get(i).getName(), variables.get(i).getValue());
                ++i;
            }
            return new Tuple().withElements(elementMap);
        }
        return elements.get(0);
    }

    public void sortResult(List<Object> result, Context context, String alias) {
        SortClause sortClause = this.getSort();
        if (sortClause != null) {
            for (SortByItem byItem : sortClause.getBy()) {
                if (byItem instanceof ByExpression) {
                    result.sort(new CqlList((Context)context, (String)alias, (Expression)((ByExpression)byItem).getExpression()).expressionSort);
                } else if (byItem instanceof ByColumn) {
                    result.sort(new CqlList((Context)context, (String)((ByColumn)byItem).getPath()).columnSort);
                } else {
                    result.sort(new CqlList().valueSort);
                }
                String direction = byItem.getDirection().value();
                if (!direction.equals("desc") && !direction.equals("descending")) continue;
                Collections.reverse(result);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected Object internalEvaluate(Context context) {
        sources = new ArrayList<Iterator<Object>>();
        variables = new ArrayList<Variable>();
        letVariables = new ArrayList<Variable>();
        result = new ArrayList<Object>();
        sourceIsList = false;
        pushCount = 0;
        try {
            for (AliasedQuerySource source : this.getSource()) {
                querySource = new QuerySource(source.getAlias(), source.getExpression().evaluate(context));
                sources.add(querySource.getData().iterator());
                if (querySource.getIsList()) {
                    sourceIsList = true;
                }
                variable = new Variable().withName(source.getAlias());
                variables.add(variable);
                context.push(variable);
                ++pushCount;
            }
            for (LetClause let : this.getLet()) {
                letVariable = new Variable().withName(let.getIdentifier());
                letVariables.add(letVariable);
                context.push(letVariable);
                ++pushCount;
            }
            iterator = new QueryIterator(context, sources);
            while (iterator.hasNext()) {
                elements = (List)iterator.next();
                this.assignVariables(variables, elements);
                this.evaluateLets(context, letVariables);
                if (!this.evaluateRelationships(context) || !this.evaluateWhere(context)) continue;
                result.add(this.evaluateReturn(context, variables, elements));
            }
            if (true) ** GOTO lbl46
        }
        catch (Throwable var12_12) {
            ** while (pushCount > 0)
        }
lbl-1000:
        // 1 sources

        {
            context.pop();
            --pushCount;
            continue;
        }
lbl42:
        // 1 sources

        throw var12_12;
        do {
            context.pop();
            --pushCount;
lbl46:
            // 2 sources

        } while (pushCount > 0);
        if (this.getReturn() != null && this.getReturn().isDistinct()) {
            result = DistinctEvaluator.distinct(result);
        }
        this.sortResult(result, context, null);
        if ((result == null || result.isEmpty()) && !sourceIsList) {
            return null;
        }
        return sourceIsList != false ? result : result.get(0);
    }

    private void assignVariables(List<Variable> variables, List<Object> elements) {
        int i = 0;
        while (i < variables.size()) {
            variables.get(i).setValue(elements.get(i));
            ++i;
        }
    }

    class QuerySource {
        private String alias;
        private boolean isList;
        private Iterable<Object> data;

        public QuerySource(String alias, Object data) {
            this.alias = alias;
            this.isList = data instanceof Iterable;
            this.data = QueryEvaluator.this.ensureIterable(data);
        }

        public String getAlias() {
            return this.alias;
        }

        public boolean getIsList() {
            return this.isList;
        }

        public Iterable<Object> getData() {
            return this.data;
        }
    }
}

