/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.Subtract;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.TemporalHelper;
import org.opencds.cqf.cql.engine.runtime.Time;

public class SubtractEvaluator
extends Subtract {
    public static Object subtract(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer) {
            return (Integer)left - (Integer)right;
        }
        if (left instanceof Long) {
            return (Long)left - (Long)right;
        }
        if (left instanceof BigDecimal) {
            return ((BigDecimal)left).subtract((BigDecimal)right);
        }
        if (left instanceof Quantity) {
            return new Quantity().withValue(((Quantity)left).getValue().subtract(((Quantity)right).getValue())).withUnit(((Quantity)left).getUnit());
        }
        if (left instanceof BaseTemporal && right instanceof Quantity) {
            Precision precision = Precision.fromString(((Quantity)right).getUnit());
            int valueToSubtract = ((Quantity)right).getValue().intValue();
            if (left instanceof DateTime) {
                if (precision == Precision.WEEK) {
                    valueToSubtract = TemporalHelper.weeksToDays(valueToSubtract);
                    precision = Precision.DAY;
                }
                return new DateTime(((DateTime)left).getDateTime().minus(valueToSubtract, precision.toChronoUnit()), ((DateTime)left).getPrecision());
            }
            if (left instanceof Date) {
                if (precision == Precision.WEEK) {
                    valueToSubtract = TemporalHelper.weeksToDays(valueToSubtract);
                    precision = Precision.DAY;
                }
                return new Date(((Date)left).getDate().minus(valueToSubtract, precision.toChronoUnit())).setPrecision(((Date)left).getPrecision());
            }
            return new Time(((Time)left).getTime().minus(valueToSubtract, precision.toChronoUnit()), ((Time)left).getPrecision());
        }
        if (left instanceof Interval && right instanceof Interval) {
            Interval leftInterval = (Interval)left;
            Interval rightInterval = (Interval)right;
            return new Interval(SubtractEvaluator.subtract(leftInterval.getStart(), rightInterval.getStart()), true, SubtractEvaluator.subtract(leftInterval.getEnd(), rightInterval.getEnd()), true);
        }
        throw new InvalidOperatorArgument("Subtract(Integer, Integer), Subtract(Long, Long) Subtract(Decimal, Decimal), Subtract(Quantity, Quantity), Subtract(Date, Quantity), Subtract(DateTime, Quantity), Subtract(Time, Quantity)", String.format("Subtract(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        return SubtractEvaluator.subtract(left, right);
    }
}

