/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.ToQuantity;
import org.opencds.cqf.cql.engine.elm.execution.DivideEvaluator;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.Ratio;
import org.opencds.cqf.cql.engine.runtime.Value;

public class ToQuantityEvaluator
extends ToQuantity {
    public static Quantity toQuantity(String str) {
        str = str.trim();
        int index = str.indexOf(32);
        String number = str;
        Quantity quantity = new Quantity();
        if (index > 0) {
            number = str.substring(0, index);
            quantity.setUnit(str.substring(index + 1).replaceAll("[' ]", ""));
        }
        quantity = ToQuantityEvaluator.setValue(quantity, number);
        return quantity;
    }

    private static Quantity setValue(Quantity quantity, String str) {
        BigDecimal number;
        block3: {
            try {
                number = new BigDecimal(str);
                if (Value.validateDecimal(number, null) != null) break block3;
                return null;
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        quantity.setValue(number);
        return quantity;
    }

    public static Quantity toQuantity(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof Quantity) {
            return (Quantity)operand;
        }
        if (operand instanceof String) {
            String str = (String)operand;
            return ToQuantityEvaluator.toQuantity(str);
        }
        if (operand instanceof Integer) {
            BigDecimal ret = new BigDecimal((Integer)operand);
            if (Value.validateDecimal(ret, null) == null) {
                return null;
            }
            return new Quantity().withValue(ret).withDefaultUnit();
        }
        if (operand instanceof BigDecimal) {
            if (Value.validateDecimal((BigDecimal)operand, null) == null) {
                return null;
            }
            return new Quantity().withValue((BigDecimal)operand).withDefaultUnit();
        }
        if (operand instanceof Ratio) {
            return (Quantity)DivideEvaluator.divide(((Ratio)operand).getNumerator(), ((Ratio)operand).getDenominator());
        }
        throw new IllegalArgumentException(String.format("Cannot cast a value of type %s as Quantity - use String, Integer, Decimal, or Ratio values.", operand.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        return ToQuantityEvaluator.toQuantity(operand);
    }
}

