/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.execution;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.IOException;
import java.io.Reader;
import org.cqframework.cql.elm.execution.Element;
import org.cqframework.cql.elm.execution.Expression;
import org.cqframework.cql.elm.execution.Library;
import org.cqframework.cql.elm.execution.TypeSpecifier;
import org.opencds.cqf.cql.engine.elm.execution.ElementMixin;
import org.opencds.cqf.cql.engine.elm.execution.ExpressionMixin;
import org.opencds.cqf.cql.engine.elm.execution.LibraryWrapper;
import org.opencds.cqf.cql.engine.elm.execution.TypeSpecifierMixin;

public class JsonCqlLibraryReader {
    private JsonCqlLibraryReader() {
    }

    public static Library read(Reader reader) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        JaxbAnnotationModule module = new JaxbAnnotationModule();
        mapper.registerModule((Module)module);
        SimpleModule simpleModule = new SimpleModule();
        simpleModule.setMixInAnnotation(Element.class, ElementMixin.class);
        simpleModule.setMixInAnnotation(Expression.class, ExpressionMixin.class);
        simpleModule.setMixInAnnotation(TypeSpecifier.class, TypeSpecifierMixin.class);
        mapper.registerModule((Module)simpleModule);
        Library result = ((LibraryWrapper)mapper.readValue(reader, LibraryWrapper.class)).getLibrary();
        return result;
    }
}

