/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.time.Instant;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import org.opencds.cqf.cql.engine.exception.InvalidDate;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.TemporalHelper;

public class Date
extends BaseTemporal {
    private LocalDate date;

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        if (date.getYear() < 1) {
            throw new InvalidDate(String.format("The year: %d falls below the accepted bounds of 0001-9999.", date.getYear()));
        }
        if (date.getYear() > 9999) {
            throw new InvalidDate(String.format("The year: %d falls above the accepted bounds of 0001-9999.", date.getYear()));
        }
        if (this.precision == null) {
            this.precision = Precision.DAY;
        }
        this.date = date;
    }

    public Date(int year) {
        this.setDate(LocalDate.of(year, 1, 1));
        this.precision = Precision.YEAR;
    }

    public Date(int year, int month) {
        this.setDate(LocalDate.of(year, month, 1));
        this.precision = Precision.MONTH;
    }

    public Date(int year, int month, int day) {
        this.setDate(LocalDate.of(year, month, day));
    }

    public Date(LocalDate date, Precision precision) {
        this.date = date;
        this.precision = precision;
    }

    public Date(String dateString) {
        this.precision = Precision.fromDateIndex(dateString.split("-").length - 1);
        dateString = TemporalHelper.autoCompleteDateString(dateString, this.precision);
        this.setDate(LocalDate.parse(dateString));
    }

    public Date(LocalDate date) {
        this.setDate(date);
    }

    public Date expandPartialMinFromPrecision(Precision thePrecision) {
        LocalDate ld = this.getDate().plusYears(0L);
        int i = thePrecision.toDateIndex() + 1;
        while (i < 3) {
            ld = ld.with(Precision.fromDateIndex(i).toChronoField(), ld.range(Precision.fromDateIndex(i).toChronoField()).getMinimum());
            ++i;
        }
        return (Date)new Date(ld.getYear(), ld.getMonthValue(), ld.getDayOfMonth()).setPrecision(thePrecision);
    }

    private Date expandPartialMin(Precision thePrecision) {
        LocalDate ld = this.getDate().plusYears(0L);
        return (Date)new Date(ld.getYear(), ld.getMonthValue(), ld.getDayOfMonth()).setPrecision(thePrecision);
    }

    public Date expandPartialMax(Precision thePrecision) {
        LocalDate ld = this.getDate().plusYears(0L);
        int i = this.getPrecision().toDateIndex() + 1;
        while (i < 3) {
            ld = i <= thePrecision.toDateIndex() ? ld.with(Precision.fromDateIndex(i).toChronoField(), ld.range(Precision.fromDateIndex(i).toChronoField()).getMaximum()) : ld.with(Precision.fromDateIndex(i).toChronoField(), ld.range(Precision.fromDateIndex(i).toChronoField()).getMinimum());
            ++i;
        }
        return (Date)new Date(ld.getYear(), ld.getMonthValue(), ld.getDayOfMonth()).setPrecision(thePrecision);
    }

    @Override
    public Integer compare(BaseTemporal other, boolean forSort) {
        boolean differentPrecisions;
        boolean bl = differentPrecisions = this.getPrecision() != other.getPrecision();
        if (differentPrecisions) {
            Integer result = this.compareToPrecision(other, Precision.getHighestDatePrecision(this.precision, other.precision));
            if (result == null && forSort) {
                return this.precision.toDateIndex() > other.precision.toDateIndex() ? 1 : -1;
            }
            return result;
        }
        return this.compareToPrecision(other, this.precision);
    }

    @Override
    public Integer compareToPrecision(BaseTemporal other, Precision thePrecision) {
        boolean rightMeetsPrecisionRequirements;
        boolean leftMeetsPrecisionRequirements = this.precision.toDateIndex() >= thePrecision.toDateIndex();
        boolean bl = rightMeetsPrecisionRequirements = other.precision.toDateIndex() >= thePrecision.toDateIndex();
        if (!leftMeetsPrecisionRequirements || !rightMeetsPrecisionRequirements) {
            thePrecision = Precision.getLowestDatePrecision(this.precision, other.precision);
        }
        int i = 0;
        while (i < thePrecision.toDateIndex() + 1) {
            int rightComp;
            int leftComp = this.date.get(Precision.getDateChronoFieldFromIndex(i));
            if (leftComp > (rightComp = ((Date)other).getDate().get(Precision.getDateChronoFieldFromIndex(i)))) {
                return 1;
            }
            if (leftComp < rightComp) {
                return -1;
            }
            ++i;
        }
        if (leftMeetsPrecisionRequirements && rightMeetsPrecisionRequirements) {
            return 0;
        }
        return null;
    }

    @Override
    public boolean isUncertain(Precision thePrecision) {
        if (thePrecision == Precision.WEEK) {
            thePrecision = Precision.DAY;
        }
        return this.precision.toDateIndex() < thePrecision.toDateIndex();
    }

    @Override
    public Interval getUncertaintyInterval(Precision thePrecision) {
        Date start = this.expandPartialMin(thePrecision);
        Date end = this.expandPartialMax(thePrecision).expandPartialMinFromPrecision(thePrecision);
        return new Interval(start, true, end, true);
    }

    @Override
    public int compareTo(@Nonnull BaseTemporal other) {
        return this.compare(other, true);
    }

    @Override
    public Boolean equivalent(Object other) {
        Integer comparison = this.compare((BaseTemporal)other, false);
        if (comparison != null && comparison == 0) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean equal(Object other) {
        Integer comparison = this.compare((BaseTemporal)other, false);
        return comparison == null ? null : Boolean.valueOf(comparison == 0);
    }

    public String toString() {
        switch (this.precision) {
            case YEAR: {
                return String.format("%04d", this.date.getYear());
            }
            case MONTH: {
                return String.format("%04d-%02d", this.date.getYear(), this.date.getMonthValue());
            }
        }
        return String.format("%04d-%02d-%02d", this.date.getYear(), this.date.getMonthValue(), this.date.getDayOfMonth());
    }

    public java.util.Date toJavaDate() {
        ZonedDateTime zonedDateTime = null;
        Context c = Context.getContext();
        zonedDateTime = c != null ? this.date.atStartOfDay(c.getEvaluationZonedDateTime().getZone()) : this.date.atStartOfDay(TimeZone.getDefault().toZoneId());
        Instant instant = zonedDateTime.toInstant();
        java.util.Date date = java.util.Date.from(instant);
        return date;
    }

    public static DateTime fromJavaDate(java.util.Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return new DateTime(OffsetDateTime.ofInstant(calendar.toInstant(), calendar.getTimeZone().toZoneId()), Precision.MILLISECOND);
    }
}

