/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Objects;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Precision;

public class TemporalHelper {
    private TemporalHelper() {
    }

    public static String[] normalizeDateTimeElements(int ... elements) {
        String[] ret = new String[elements.length];
        int i = 0;
        while (i < elements.length) {
            switch (i) {
                case 0: {
                    ret[i] = TemporalHelper.addLeadingZeroes(elements[i], 4);
                    break;
                }
                case 6: {
                    ret[i] = TemporalHelper.addLeadingZeroes(elements[i], 3);
                    break;
                }
                default: {
                    ret[i] = TemporalHelper.addLeadingZeroes(elements[i], 2);
                }
            }
            ++i;
        }
        return ret;
    }

    public static String[] normalizeTimeElements(int ... elements) {
        String[] ret = new String[elements.length];
        int i = 0;
        while (i < elements.length) {
            switch (i) {
                case 3: {
                    ret[i] = TemporalHelper.addLeadingZeroes(elements[i], 3);
                    break;
                }
                default: {
                    ret[i] = TemporalHelper.addLeadingZeroes(elements[i], 2);
                }
            }
            ++i;
        }
        return ret;
    }

    public static String addLeadingZeroes(int element, int length) {
        String strElement = Integer.toString(element);
        return String.valueOf(StringUtils.repeat((String)"0", (int)(length - strElement.length()))) + strElement;
    }

    public static String autoCompleteDateTimeString(String dateString, Precision precision) {
        switch (precision) {
            case YEAR: {
                return String.valueOf(dateString) + "-01-01T00:00:00.000";
            }
            case MONTH: {
                return String.valueOf(dateString) + "-01T00:00:00.000";
            }
            case DAY: {
                return String.valueOf(dateString) + "T00:00:00.000";
            }
            case HOUR: {
                return String.valueOf(dateString) + ":00:00.000";
            }
            case MINUTE: {
                return String.valueOf(dateString) + ":00.000";
            }
            case SECOND: {
                return String.valueOf(dateString) + ".000";
            }
        }
        return dateString;
    }

    public static String autoCompleteDateString(String dateString, Precision precision) {
        switch (precision) {
            case YEAR: {
                return String.valueOf(dateString) + "-01-01";
            }
            case MONTH: {
                return String.valueOf(dateString) + "-01";
            }
        }
        return dateString;
    }

    public static String autoCompleteTimeString(String timeString, Precision precision) {
        switch (precision) {
            case HOUR: 
            case MINUTE: {
                return String.valueOf(timeString) + ":00.000";
            }
            case SECOND: {
                return String.valueOf(timeString) + ".000";
            }
        }
        return timeString;
    }

    public static int[] cleanArray(Integer ... elements) {
        return Arrays.stream(elements).filter(Objects::nonNull).mapToInt(x -> x).toArray();
    }

    public static BigDecimal zoneToOffset(ZoneOffset zone) {
        int seconds = zone.get(ChronoField.OFFSET_SECONDS);
        return new BigDecimal(Double.toString((float)seconds / 60.0f / 60.0f));
    }

    public static ZonedDateTime toZonedDateTime(LocalDateTime localDateTime) {
        Context c = Context.getContext();
        if (c != null) {
            return localDateTime.atZone(c.getEvaluationZonedDateTime().getZone());
        }
        return localDateTime.atZone(TimeZone.getDefault().toZoneId());
    }

    public static OffsetDateTime toOffsetDateTime(LocalDateTime localDateTime) {
        return TemporalHelper.toZonedDateTime(localDateTime).toOffsetDateTime();
    }

    public static int weeksToDays(int weeks) {
        int years = 0;
        if (weeks >= 52) {
            years = weeks / 52;
            weeks -= years * 52;
        }
        return weeks * 7 + years * 365;
    }
}

