/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.Ends;
import org.opencds.cqf.cql.engine.elm.execution.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SameAsEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SameOrAfterEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class EndsEvaluator
extends Ends {
    public static Boolean ends(Object left, Object right, String precision) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval && right instanceof Interval) {
            Object leftStart = ((Interval)left).getStart();
            Object leftEnd = ((Interval)left).getEnd();
            Object rightStart = ((Interval)right).getStart();
            Object rightEnd = ((Interval)right).getEnd();
            if (leftStart instanceof BaseTemporal && rightStart instanceof BaseTemporal) {
                return AndEvaluator.and(SameOrAfterEvaluator.sameOrAfter(leftStart, rightStart, precision), SameAsEvaluator.sameAs(leftEnd, rightEnd, precision));
            }
            return AndEvaluator.and(GreaterOrEqualEvaluator.greaterOrEqual(leftStart, rightStart), EqualEvaluator.equal(leftEnd, rightEnd));
        }
        throw new InvalidOperatorArgument("Ends(Interval<T>, Interval<T>)", String.format("Ends(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String precision = this.getPrecision() == null ? null : this.getPrecision().value();
        return EndsEvaluator.ends(left, right, precision);
    }
}

