/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.cqframework.cql.elm.execution.Equivalent;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.CqlList;
import org.opencds.cqf.cql.engine.runtime.CqlType;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Value;

public class EquivalentEvaluator
extends Equivalent {
    public static Boolean equivalent(Object left, Object right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof Interval && right instanceof Integer) {
            return ((Interval)left).equivalent(right);
        }
        if (right instanceof Interval && left instanceof Integer) {
            return ((Interval)right).equivalent(left);
        }
        if (!left.getClass().equals(right.getClass())) {
            return false;
        }
        if (left instanceof Boolean || left instanceof Integer) {
            return left.equals(right);
        }
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            BigDecimal leftDecimal = Value.verifyPrecision((BigDecimal)left, 0);
            BigDecimal rightDecimal = Value.verifyPrecision((BigDecimal)right, 0);
            int minScale = Math.min(leftDecimal.scale(), rightDecimal.scale());
            if (minScale >= 0) {
                return leftDecimal.setScale(minScale, RoundingMode.FLOOR).compareTo(rightDecimal.setScale(minScale, RoundingMode.FLOOR)) == 0;
            }
            return leftDecimal.compareTo(rightDecimal) == 0;
        }
        if (left instanceof Iterable) {
            return CqlList.equivalent((Iterable)left, (Iterable)right);
        }
        if (left instanceof CqlType) {
            return ((CqlType)left).equivalent(right);
        }
        if (left instanceof String && right instanceof String) {
            return ((String)left).equalsIgnoreCase((String)right);
        }
        return Context.getContext().objectEquivalent(left, right);
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        return EquivalentEvaluator.equivalent(left, right);
    }
}

