/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.OverlapsBefore;
import org.opencds.cqf.cql.engine.elm.execution.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.BeforeEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.LessEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.OverlapsEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class OverlapsBeforeEvaluator
extends OverlapsBefore {
    public static Object overlapsBefore(Object left, Object right, String precision) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval && right instanceof Interval) {
            Object leftStart = ((Interval)left).getStart();
            Object rightStart = ((Interval)right).getStart();
            if (leftStart instanceof BaseTemporal && rightStart instanceof BaseTemporal) {
                return AndEvaluator.and(BeforeEvaluator.before(leftStart, rightStart, precision), OverlapsEvaluator.overlaps(left, right, precision));
            }
            return AndEvaluator.and(LessEvaluator.less(leftStart, rightStart), OverlapsEvaluator.overlaps(left, right, precision));
        }
        throw new InvalidOperatorArgument("OverlapsBefore(Interval<T>, Interval<T>)", String.format("OverlapsBefore(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String precision = this.getPrecision() == null ? null : this.getPrecision().value();
        return OverlapsBeforeEvaluator.overlapsBefore(left, right, precision);
    }
}

