/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.SameAs;
import org.opencds.cqf.cql.engine.elm.execution.EqualEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;

public class SameAsEvaluator
extends SameAs {
    public static Boolean sameAs(Object left, Object right, String precision) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval && right instanceof Interval) {
            Object leftStart = ((Interval)left).getStart();
            Object leftEnd = ((Interval)left).getEnd();
            Object rightStart = ((Interval)right).getStart();
            Object rightEnd = ((Interval)right).getEnd();
            if (leftStart instanceof BaseTemporal && leftEnd instanceof BaseTemporal && rightStart instanceof BaseTemporal && rightEnd instanceof BaseTemporal) {
                String startPrecision = null;
                if (precision == null) {
                    startPrecision = BaseTemporal.getHighestPrecision((BaseTemporal)leftStart, (BaseTemporal)rightStart);
                    precision = BaseTemporal.getHighestPrecision((BaseTemporal)leftEnd, (BaseTemporal)rightEnd);
                }
                Integer startResult = ((BaseTemporal)leftStart).compareToPrecision((BaseTemporal)rightStart, Precision.fromString(startPrecision == null ? precision : startPrecision));
                Integer endResult = ((BaseTemporal)leftEnd).compareToPrecision((BaseTemporal)rightEnd, Precision.fromString(precision));
                if (startResult == null && endResult == null) {
                    return null;
                }
                if (startResult == null && endResult != 0) {
                    return false;
                }
                if (endResult == null && startResult != 0) {
                    return false;
                }
                return startResult == null || endResult == null ? null : Boolean.valueOf(startResult == 0 && endResult == 0);
            }
            Boolean startResult = EqualEvaluator.equal(leftStart, rightStart);
            Boolean endResult = EqualEvaluator.equal(leftEnd, rightEnd);
            if (startResult == null && endResult == null) {
                return null;
            }
            if (startResult == null && !endResult.booleanValue()) {
                return false;
            }
            if (endResult == null && !startResult.booleanValue()) {
                return false;
            }
            return startResult == null || endResult == null ? null : Boolean.valueOf(startResult != false && endResult != false);
        }
        if (left instanceof BaseTemporal && right instanceof BaseTemporal) {
            Integer result;
            if (precision == null) {
                precision = BaseTemporal.getHighestPrecision((BaseTemporal)left, (BaseTemporal)right);
            }
            return (result = ((BaseTemporal)left).compareToPrecision((BaseTemporal)right, Precision.fromString(precision))) == null ? null : Boolean.valueOf(result == 0);
        }
        throw new InvalidOperatorArgument("SameAs(Date, Date), SameAs(DateTime, DateTime), SameAs(Time, Time) or SameAs(Interval<T>, Interval<T>)", String.format("SameAs(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String precision = this.getPrecision() == null ? null : this.getPrecision().value();
        return SameAsEvaluator.sameAs(left, right, precision);
    }
}

