/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.ToLong;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Value;

public class ToLongEvaluator
extends ToLong {
    public static Object toLong(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof Boolean) {
            return (Boolean)operand != false ? 1 : 0;
        }
        if (operand instanceof Integer) {
            return (Long)operand;
        }
        if (operand instanceof String) {
            try {
                return Long.parseLong((String)operand);
            }
            catch (NumberFormatException nfe) {
                try {
                    Double ret = Double.parseDouble((String)operand);
                    if (Value.validateLong(ret) == null) {
                        return null;
                    }
                    return ret.longValue();
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        }
        throw new InvalidOperatorArgument("ToLong(String)", String.format("ToLong(%s)", operand.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        return ToLongEvaluator.toLong(operand);
    }
}

