/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.cqframework.cql.elm.execution.Variance;
import org.opencds.cqf.cql.engine.elm.execution.AvgEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.DivideEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.MultiplyEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SubtractEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SumEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class VarianceEvaluator
extends Variance {
    public static Object variance(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Iterable) {
            if (((List)source).isEmpty()) {
                return null;
            }
            Object mean = AvgEvaluator.avg(source);
            ArrayList<Object> newVals = new ArrayList<Object>();
            for (Object element : (Iterable)source) {
                if (element == null) continue;
                if (element instanceof BigDecimal || element instanceof Quantity) {
                    newVals.add(MultiplyEvaluator.multiply(SubtractEvaluator.subtract(element, mean), SubtractEvaluator.subtract(element, mean)));
                    continue;
                }
                throw new InvalidOperatorArgument("Variance(List<Decimal>) or Variance(List<Quantity>)", String.format("Variance(List<%s>)", element.getClass().getName()));
            }
            return DivideEvaluator.divide(SumEvaluator.sum(newVals), new BigDecimal(newVals.size() - 1));
        }
        throw new InvalidOperatorArgument("Variance(List<Decimal>) or Variance(List<Quantity>)", String.format("Variance(%s)", source.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object source = this.getSource().evaluate(context);
        return VarianceEvaluator.variance(source);
    }
}

