/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.lang.reflect.InvocationTargetException;
import org.cqframework.cql.elm.execution.Convert;
import org.opencds.cqf.cql.engine.exception.InvalidConversion;
import org.opencds.cqf.cql.engine.execution.Context;

public class ConvertEvaluator
extends Convert {
    private Class<?> resolveType(Context context) {
        if (this.getToTypeSpecifier() != null) {
            return context.resolveType(this.getToTypeSpecifier());
        }
        return context.resolveType(this.getToType());
    }

    private static Object convert(Object operand, Class<?> type) {
        if (operand == null) {
            return null;
        }
        try {
            if (type.isInstance(operand)) {
                Class<?> cls = operand.getClass();
                return cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (ExceptionInInitializerError | IllegalAccessException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new InvalidConversion("Error during conversion: " + e.getMessage());
        }
        throw new InvalidConversion(operand, type);
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        Class<?> type = this.resolveType(context);
        return ConvertEvaluator.convert(operand, type);
    }
}

