/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.Greater;
import org.opencds.cqf.cql.engine.elm.execution.InEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class GreaterEvaluator
extends Greater {
    public static Boolean greater(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer && right instanceof Integer) {
            if (((Integer)left).compareTo((Integer)right) > 0) {
                return true;
            }
            return false;
        }
        if (left instanceof Long && right instanceof Long) {
            if (((Long)left).compareTo((Long)right) > 0) {
                return true;
            }
            return false;
        }
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            if (((BigDecimal)left).compareTo((BigDecimal)right) > 0) {
                return true;
            }
            return false;
        }
        if (left instanceof Quantity && right instanceof Quantity) {
            if (((Quantity)left).getValue() == null || ((Quantity)right).getValue() == null) {
                return null;
            }
            Integer nullableCompareTo = ((Quantity)left).nullableCompareTo((Quantity)right);
            return nullableCompareTo == null ? null : Boolean.valueOf(nullableCompareTo > 0);
        }
        if (left instanceof BaseTemporal && right instanceof BaseTemporal) {
            Integer i = ((BaseTemporal)left).compare((BaseTemporal)right, false);
            return i == null ? null : Boolean.valueOf(i > 0);
        }
        if (left instanceof String && right instanceof String) {
            if (((String)left).compareTo((String)right) > 0) {
                return true;
            }
            return false;
        }
        if (left instanceof Interval && right instanceof Integer) {
            if (InEvaluator.in(right, left, null).booleanValue()) {
                return null;
            }
            if (((Integer)((Interval)left).getStart()).compareTo((Integer)right) > 0) {
                return true;
            }
            return false;
        }
        if (left instanceof Integer && right instanceof Interval) {
            if (InEvaluator.in(left, right, null).booleanValue()) {
                return null;
            }
            if (((Integer)left).compareTo((Integer)((Interval)right).getEnd()) > 0) {
                return true;
            }
            return false;
        }
        throw new InvalidOperatorArgument("Greater(Integer, Integer), Greater(Long, Long), Greater(Decimal, Decimal), Greater(Quantity, Quantity), Greater(Date, Date), Greater(DateTime, DateTime), Greater(Time, Time) or Greater(String, String)", String.format("Greater(%s, %s)", left, right));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        return GreaterEvaluator.greater(left, right);
    }
}

