/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.InCodeSystem;
import org.opencds.cqf.cql.engine.elm.execution.CodeSystemRefEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.CodeSystem;
import org.opencds.cqf.cql.engine.runtime.Concept;
import org.opencds.cqf.cql.engine.terminology.CodeSystemInfo;
import org.opencds.cqf.cql.engine.terminology.TerminologyProvider;

public class InCodeSystemEvaluator
extends InCodeSystem {
    public static Object inCodeSystem(Context context, Object code, Object codeSystem) {
        if (code == null || codeSystem == null) {
            return null;
        }
        if (codeSystem instanceof CodeSystem) {
            CodeSystemInfo csi = CodeSystemInfo.fromCodeSystem((CodeSystem)codeSystem);
            TerminologyProvider provider = context.resolveTerminologyProvider();
            if (code instanceof String) {
                if (provider.lookup(new Code().withCode((String)code), csi) != null) {
                    return true;
                }
                return false;
            }
            if (code instanceof Code) {
                if (provider.lookup((Code)code, csi) != null) {
                    return true;
                }
                return false;
            }
            if (code instanceof Concept) {
                for (Code codes : ((Concept)code).getCodes()) {
                    if (provider.lookup(codes, csi) == null) continue;
                    return true;
                }
                return false;
            }
        }
        throw new InvalidOperatorArgument("In(String, CodeSystemRef), In(Code, CodeSystemRef) or In(Concept, CodeSystemRef)", String.format("In(%s, %s)", code.getClass().getName(), codeSystem.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object code = this.getCode().evaluate(context);
        Object cs = null;
        if (this.getCodesystem() != null) {
            cs = CodeSystemRefEvaluator.toCodeSystem(context, this.getCodesystem());
        } else if (this.getCodesystemExpression() != null) {
            cs = this.getCodesystemExpression().evaluate(context);
        }
        return InCodeSystemEvaluator.inCodeSystem(context, code, cs);
    }
}

