/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.Predecessor;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.exception.TypeUnderflow;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.Time;
import org.opencds.cqf.cql.engine.runtime.Value;

public class PredecessorEvaluator
extends Predecessor {
    public static Object predecessor(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            if ((Integer)value <= Value.MIN_INT) {
                throw new TypeUnderflow("The result of the predecessor operation precedes the minimum value allowed for the Integer type");
            }
            return (Integer)value - 1;
        }
        if (value instanceof Long) {
            if ((Long)value <= Value.MIN_LONG) {
                throw new TypeUnderflow("The result of the predecessor operation precedes the minimum value allowed for the Long type");
            }
            return (Long)value - 1L;
        }
        if (value instanceof BigDecimal) {
            if (((BigDecimal)value).compareTo(Value.MIN_DECIMAL) <= 0) {
                throw new TypeUnderflow("The result of the predecessor operation precedes the minimum value allowed for the Decimal type");
            }
            return ((BigDecimal)value).subtract(new BigDecimal("0.00000001"));
        }
        if (value instanceof Quantity) {
            if (((Quantity)value).getValue().compareTo(Value.MIN_DECIMAL) <= 0) {
                throw new TypeUnderflow("The result of the predecessor operation precedes the minimum value allowed for the Decimal type");
            }
            Quantity quantity = (Quantity)value;
            return new Quantity().withValue((BigDecimal)PredecessorEvaluator.predecessor(quantity.getValue())).withUnit(quantity.getUnit());
        }
        if (value instanceof Date) {
            Date dt = (Date)value;
            return new Date(dt.getDate().minus(1L, dt.getPrecision().toChronoUnit()), dt.getPrecision());
        }
        if (value instanceof DateTime) {
            DateTime dt = (DateTime)value;
            return new DateTime(dt.getDateTime().minus(1L, dt.getPrecision().toChronoUnit()), dt.getPrecision());
        }
        if (value instanceof Time) {
            Time t = (Time)value;
            switch (t.getPrecision()) {
                case HOUR: {
                    if (t.getTime().getHour() != 0) break;
                    throw new TypeUnderflow("The result of the successor operation precedes the minimum value allowed for the Time type");
                }
                case MINUTE: {
                    if (t.getTime().getHour() != 0 || t.getTime().getMinute() != 0) break;
                    throw new TypeUnderflow("The result of the successor operation precedes the minimum value allowed for the Time type");
                }
                case SECOND: {
                    if (t.getTime().getHour() != 0 || t.getTime().getMinute() != 0 || t.getTime().getSecond() != 0) break;
                    throw new TypeUnderflow("The result of the successor operation precedes the minimum value allowed for the Time type");
                }
                case MILLISECOND: {
                    if (t.getTime().getHour() != 0 || t.getTime().getMinute() != 0 || t.getTime().getSecond() != 0 || t.getTime().get(Precision.MILLISECOND.toChronoField()) != 0) break;
                    throw new TypeUnderflow("The result of the successor operation precedes the minimum value allowed for the Time type");
                }
            }
            return new Time(t.getTime().minus(1L, t.getPrecision().toChronoUnit()), t.getPrecision());
        }
        throw new InvalidOperatorArgument(String.format("The Predecessor operation is not implemented for type %s", value.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object value = this.getOperand().evaluate(context);
        return PredecessorEvaluator.predecessor(value);
    }
}

