/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.util.List;
import org.cqframework.cql.elm.execution.ProperContains;
import org.opencds.cqf.cql.engine.elm.execution.AfterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.BeforeEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.EquivalentEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.LessEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class ProperContainsEvaluator
extends ProperContains {
    public static Boolean properContains(Object left, Object right) {
        if (left instanceof Interval) {
            Boolean startProperContains = GreaterEvaluator.greater(right, ((Interval)left).getStart());
            Boolean endProperContains = LessEvaluator.less(right, ((Interval)left).getEnd());
            return startProperContains == null ? null : (endProperContains == null ? null : Boolean.valueOf(startProperContains != false && endProperContains != false));
        }
        if (left instanceof Iterable) {
            List leftList = (List)left;
            for (Object element : leftList) {
                Boolean isElementInList = EquivalentEvaluator.equivalent(element, right);
                if (isElementInList == null) {
                    return null;
                }
                if (!isElementInList.booleanValue() || leftList.size() <= 1) continue;
                return true;
            }
            return false;
        }
        throw new InvalidOperatorArgument("ProperContains(List<T>, T) or ProperContains(Interval<T>, T)", String.format("ProperContains(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    public static Boolean properContains(Object left, Object right, String precision) {
        if (left instanceof Interval && right instanceof BaseTemporal) {
            Boolean startProperContains = AfterEvaluator.after(right, ((Interval)left).getStart(), precision);
            Boolean endProperContains = BeforeEvaluator.before(right, ((Interval)left).getEnd(), precision);
            return startProperContains == null ? null : (endProperContains == null ? null : Boolean.valueOf(startProperContains != false && endProperContains != false));
        }
        return ProperContainsEvaluator.properContains(left, right);
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String precision = this.getPrecision() != null ? this.getPrecision().value() : null;
        return ProperContainsEvaluator.properContains(left, right, precision);
    }
}

