/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.ToInteger;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Value;

public class ToIntegerEvaluator
extends ToInteger {
    public static Object toInteger(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof Boolean) {
            return (Boolean)operand != false ? 1 : 0;
        }
        if (operand instanceof Integer) {
            return operand;
        }
        if (operand instanceof String) {
            try {
                return Integer.parseInt((String)operand);
            }
            catch (NumberFormatException nfe) {
                Double ret;
                block9: {
                    try {
                        ret = Double.parseDouble((String)operand);
                        if (Value.validateInteger(ret) != null) break block9;
                        return null;
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                return ret.intValue();
            }
        }
        throw new InvalidOperatorArgument("ToInteger(String)", String.format("ToInteger(%s)", operand.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        return ToIntegerEvaluator.toInteger(operand);
    }
}

