/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Date;
import org.opencds.cqf.cql.engine.elm.execution.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.EquivalentEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.IntersectEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.MaxValueEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.MinValueEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.PredecessorEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SubtractEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SuccessorEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidInterval;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.runtime.CqlList;
import org.opencds.cqf.cql.engine.runtime.CqlType;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class Interval
implements CqlType,
Comparable<Interval> {
    private Object low;
    private boolean lowClosed;
    private Object high;
    private boolean highClosed;
    private Type pointType;
    private boolean uncertain = false;

    public Interval(Object low, boolean lowClosed, Object high, boolean highClosed) {
        Boolean isStartGreater;
        this.low = low;
        this.lowClosed = lowClosed;
        this.high = high;
        this.highClosed = highClosed;
        if (this.low != null) {
            this.pointType = this.low.getClass();
        } else if (this.high != null) {
            this.pointType = this.high.getClass();
        }
        if (this.pointType == null) {
            throw new InvalidInterval("Low or high boundary of an interval must be present.");
        }
        if (this.high != null && this.high.getClass() != this.pointType) {
            throw new InvalidInterval("Low and high boundary values of an interval must be of the same type.");
        }
        if (low instanceof Date && high instanceof Date ? ((Date)low).after((Date)high) : low != null && high != null && ((isStartGreater = GreaterEvaluator.greater(this.getStart(), this.getEnd())) == null || isStartGreater.equals(Boolean.TRUE))) {
            throw new InvalidInterval("Invalid Interval - the ending boundary must be greater than or equal to the starting boundary.");
        }
    }

    public static Object getSize(Object start, Object end) {
        if (start == null || end == null) {
            return null;
        }
        if (start instanceof Integer || start instanceof BigDecimal || start instanceof Quantity) {
            return SubtractEvaluator.subtract(end, start);
        }
        throw new InvalidOperatorArgument(String.format("Cannot perform width operator with argument of type '%s'.", start.getClass().getName()));
    }

    public Object getLow() {
        return this.low;
    }

    public boolean getLowClosed() {
        return this.lowClosed;
    }

    public Object getHigh() {
        return this.high;
    }

    public boolean getHighClosed() {
        return this.highClosed;
    }

    public Type getPointType() {
        return this.pointType;
    }

    public boolean isUncertain() {
        return this.uncertain;
    }

    public Interval setUncertain(boolean uncertain) {
        this.uncertain = uncertain;
        return this;
    }

    public Object getStart() {
        if (!this.lowClosed) {
            return SuccessorEvaluator.successor(this.low);
        }
        return this.low == null ? MinValueEvaluator.minValue(this.pointType.getTypeName()) : this.low;
    }

    public Object getEnd() {
        if (!this.highClosed) {
            return PredecessorEvaluator.predecessor(this.high);
        }
        return this.high == null ? MaxValueEvaluator.maxValue(this.pointType.getTypeName()) : this.high;
    }

    @Override
    public int compareTo(Interval other) {
        CqlList cqlList = new CqlList();
        if (cqlList.compareTo(this.getStart(), other.getStart()) == 0) {
            return cqlList.compareTo(this.getEnd(), other.getEnd());
        }
        return cqlList.compareTo(this.getStart(), other.getStart());
    }

    @Override
    public Boolean equivalent(Object other) {
        if (EquivalentEvaluator.equivalent(this.getStart(), ((Interval)other).getStart()).booleanValue() && EquivalentEvaluator.equivalent(this.getEnd(), ((Interval)other).getEnd()).booleanValue()) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean equal(Object other) {
        if (other instanceof Interval) {
            if (this.isUncertain() && IntersectEvaluator.intersect(this, other) != null) {
                return null;
            }
            Interval otherInterval = (Interval)other;
            return AndEvaluator.and(EqualEvaluator.equal(this.getStart(), otherInterval.getStart()), EqualEvaluator.equal(this.getEnd(), otherInterval.getEnd()));
        }
        if (other instanceof Integer) {
            return this.equal(new Interval(other, true, other, true));
        }
        throw new InvalidOperatorArgument(String.format("Cannot perform equal operation on types: '%s' and '%s'", this.getClass().getName(), other.getClass().getName()));
    }

    public boolean equals(Object other) {
        return other instanceof Interval ? this.equivalent(other) : false;
    }

    public int hashCode() {
        return 31 * (this.lowClosed ? 1 : 0) + 47 * (this.highClosed ? 1 : 0) + 13 * (this.low != null ? this.low.hashCode() : 0) + 89 * (this.high != null ? this.high.hashCode() : 0);
    }

    public String toString() {
        return String.format("Interval%s%s, %s%s", this.getLowClosed() ? "[" : "(", this.getLow() == null ? "null" : this.getLow().toString(), this.getHigh() == null ? "null" : this.getHigh().toString(), this.getHighClosed() ? "]" : ")");
    }
}

