/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.DateTimeComponentFrom;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Time;

public class DateTimeComponentFromEvaluator
extends DateTimeComponentFrom {
    public static Object dateTimeComponentFrom(Object operand, String precision) {
        if (operand == null) {
            return null;
        }
        if (precision == null) {
            throw new InvalidOperatorArgument("Precision must be specified for the _precision_ from operation.");
        }
        Precision p = Precision.fromString(precision);
        if (operand instanceof Date) {
            Date date = (Date)operand;
            if (p.toDateIndex() > date.getPrecision().toDateIndex()) {
                return null;
            }
            return date.getDate().get(p.toChronoField());
        }
        if (operand instanceof DateTime) {
            DateTime dateTime = (DateTime)operand;
            if (p.toDateTimeIndex() > dateTime.getPrecision().toDateTimeIndex()) {
                return null;
            }
            return dateTime.getDateTime().get(p.toChronoField());
        }
        if (operand instanceof Time) {
            Time time = (Time)operand;
            if (p.toTimeIndex() > time.getPrecision().toTimeIndex()) {
                return null;
            }
            return time.getTime().get(p.toChronoField());
        }
        throw new InvalidOperatorArgument("_precision_ from(Date), _precision_ from(DateTime) or _precision_ from(Time)", String.format("%s from(%s)", precision.toLowerCase(), operand.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        String precision = this.getPrecision().value();
        return DateTimeComponentFromEvaluator.dateTimeComponentFrom(operand, precision);
    }
}

