/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.GreaterOrEqual;
import org.opencds.cqf.cql.engine.elm.execution.GreaterEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class GreaterOrEqualEvaluator
extends GreaterOrEqual {
    public static Boolean greaterOrEqual(Object left, Object right) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Integer && right instanceof Integer) {
            return ((Integer)left).compareTo((Integer)right) >= 0;
        }
        if (left instanceof Long && right instanceof Long) {
            return ((Long)left).compareTo((Long)right) >= 0;
        }
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            return ((BigDecimal)left).compareTo((BigDecimal)right) >= 0;
        }
        if (left instanceof Quantity && right instanceof Quantity) {
            if (((Quantity)left).getValue() == null || ((Quantity)right).getValue() == null) {
                return null;
            }
            Integer nullableCompareTo = ((Quantity)left).nullableCompareTo((Quantity)right);
            return nullableCompareTo == null ? null : Boolean.valueOf(nullableCompareTo >= 0);
        }
        if (left instanceof BaseTemporal && right instanceof BaseTemporal) {
            Integer i = ((BaseTemporal)left).compare((BaseTemporal)right, false);
            return i == null ? null : Boolean.valueOf(i >= 0);
        }
        if (left instanceof String && right instanceof String) {
            return ((String)left).compareTo((String)right) >= 0;
        }
        if (left instanceof Interval && right instanceof Integer || left instanceof Integer && right instanceof Interval) {
            return GreaterEvaluator.greater(left, right);
        }
        throw new InvalidOperatorArgument("GreaterOrEqual(Integer, Integer), GreaterOrEqual(Long, Long), GreaterOrEqual(Decimal, Decimal), GreaterOrEqual(Quantity, Quantity), GreaterOrEqual(Date, Date), GreaterOrEqual(DateTime, DateTime), GreaterOrEqual(Time, Time) or GreaterOrEqual(String, String)", String.format("Cannot perform greater than or equal operator on types %s and %s", left.getClass().getSimpleName(), right.getClass().getSimpleName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        return GreaterOrEqualEvaluator.greaterOrEqual(left, right);
    }
}

