/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.cqframework.cql.elm.execution.Children;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Code;
import org.opencds.cqf.cql.engine.runtime.Concept;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Quantity;
import org.opencds.cqf.cql.engine.runtime.TemporalHelper;
import org.opencds.cqf.cql.engine.runtime.Time;

public class ChildrenEvaluator
extends Children {
    private static void addQuantity(List<Object> list, Quantity quantity) {
        list.add(quantity.getValue());
        list.add(quantity.getUnit());
    }

    private static void addCode(List<Object> list, Code code) {
        list.add(code.getSystem());
        list.add(code.getVersion());
        list.add(code.getCode());
        list.add(code.getSystem());
    }

    private static void addConcept(List<Object> list, Concept concept) {
        for (Code code : concept.getCodes()) {
            ChildrenEvaluator.addCode(list, code);
        }
        list.add(concept.getDisplay());
    }

    private static void addDateTime(List<Object> list, DateTime dateTime) {
        for (int i = 0; i < dateTime.getPrecision().toDateTimeIndex() + 1; ++i) {
            list.add(dateTime.getDateTime().get(Precision.fromDateTimeIndex(i).toChronoField()));
        }
        list.add(TemporalHelper.zoneToOffset(dateTime.getDateTime().getOffset()));
    }

    private static void addTime(List<Object> list, Time time) {
        for (int i = 0; i < time.getPrecision().toTimeIndex() + 1; ++i) {
            list.add(time.getTime().get(Precision.fromTimeIndex(i).toChronoField()));
        }
    }

    private static void addList(List<Object> list, List<Object> listToProcess) {
        for (Object o : listToProcess) {
            list.add(ChildrenEvaluator.children(o));
        }
    }

    public static Object children(Object source) {
        if (source == null) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>();
        if (source instanceof Integer || source instanceof BigDecimal || source instanceof String || source instanceof Boolean) {
            ret.add(source);
        } else if (source instanceof Quantity) {
            ChildrenEvaluator.addQuantity(ret, (Quantity)source);
        } else if (source instanceof Code) {
            ChildrenEvaluator.addCode(ret, (Code)source);
        } else if (source instanceof Concept) {
            ChildrenEvaluator.addConcept(ret, (Concept)source);
        } else if (source instanceof DateTime) {
            ChildrenEvaluator.addDateTime(ret, (DateTime)source);
        } else if (source instanceof Time) {
            ChildrenEvaluator.addTime(ret, (Time)source);
        } else if (source instanceof Iterable) {
            ChildrenEvaluator.addList(ret, (List)source);
        }
        return ret;
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object source = this.getSource().evaluate(context);
        return ChildrenEvaluator.children(source);
    }
}

