/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.Contains;
import org.cqframework.cql.elm.execution.IntervalTypeSpecifier;
import org.opencds.cqf.cql.engine.elm.execution.AsEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.InEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;

public class ContainsEvaluator
extends Contains {
    public static Object contains(Object left, Object right, String precision, Context context) {
        try {
            return InEvaluator.in(right, left, precision, context);
        }
        catch (InvalidOperatorArgument e) {
            throw new InvalidOperatorArgument("Contains(List<T>, T)", String.format("Contains(%s, %s)", left.getClass().getName(), right.getClass().getName()));
        }
    }

    @Override
    protected Object internalEvaluate(Context context) {
        String precision;
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String string = precision = this.getPrecision() == null ? null : this.getPrecision().value();
        if (left == null && right != null) {
            return false;
        }
        if (right == null) {
            return null;
        }
        if (this.getOperand().get(0) instanceof AsEvaluator) {
            if (((AsEvaluator)this.getOperand().get(0)).getAsTypeSpecifier() instanceof IntervalTypeSpecifier) {
                return InEvaluator.in(right, left, precision, context);
            }
            return InEvaluator.in(right, left, null, context);
        }
        return ContainsEvaluator.contains(left, right, precision, context);
    }
}

