/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import java.util.ArrayList;
import org.cqframework.cql.elm.execution.GeometricMean;
import org.opencds.cqf.cql.engine.elm.execution.CountEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.DivideEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.PowerEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.ProductEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.ToDecimalEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;

public class GeometricMeanEvaluator
extends GeometricMean {
    public static BigDecimal geometricMean(Iterable<?> source, Context context) {
        if (source == null) {
            return null;
        }
        ArrayList<BigDecimal> cleanSource = new ArrayList<BigDecimal>();
        for (Object element : source) {
            if (element == null) continue;
            if (element instanceof BigDecimal) {
                cleanSource.add((BigDecimal)element);
                continue;
            }
            throw new InvalidOperatorArgument("GeometricMean(List<Decimal>)", String.format("GeometricMean(%s)", element.getClass().getName()));
        }
        return (BigDecimal)PowerEvaluator.power(ProductEvaluator.product(cleanSource), DivideEvaluator.divide(new BigDecimal(1), ToDecimalEvaluator.toDecimal(CountEvaluator.count(cleanSource)), context));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        return GeometricMeanEvaluator.geometricMean((Iterable)this.getSource().evaluate(context), context);
    }
}

