/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.util.Arrays;
import org.cqframework.cql.elm.execution.In;
import org.opencds.cqf.cql.engine.elm.execution.AfterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.AnyTrueEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.BeforeEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.LessEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SameAsEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SameOrAfterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SameOrBeforeEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class InEvaluator
extends In {
    public static Boolean in(Object left, Object right, String precision, Context context) {
        if (left == null) {
            return null;
        }
        if (right == null) {
            return false;
        }
        if (right instanceof Iterable) {
            return InEvaluator.listIn(left, (Iterable)right, context);
        }
        if (right instanceof Interval) {
            return InEvaluator.intervalIn(left, (Interval)right, precision, context);
        }
        throw new InvalidOperatorArgument("In(T, Interval<T>) or In(T, List<T>)", String.format("In(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    private static Boolean intervalIn(Object left, Interval right, String precision, Context context) {
        Object rightStart = right.getStart();
        Object rightEnd = right.getEnd();
        if (left instanceof BaseTemporal) {
            if (AnyTrueEvaluator.anyTrue(Arrays.asList(SameAsEvaluator.sameAs(left, right.getStart(), precision, context), SameAsEvaluator.sameAs(left, right.getEnd(), precision, context))).booleanValue()) {
                return true;
            }
            if (AnyTrueEvaluator.anyTrue(Arrays.asList(BeforeEvaluator.before(left, right.getStart(), precision, context), AfterEvaluator.after(left, right.getEnd(), precision, context))).booleanValue()) {
                return false;
            }
            Boolean pointSameOrAfterStart = rightStart == null && right.getLowClosed() ? Boolean.valueOf(true) : SameOrAfterEvaluator.sameOrAfter(left, rightStart, precision, context);
            Boolean pointSameOrBeforeEnd = rightEnd == null && right.getHighClosed() ? Boolean.valueOf(true) : SameOrBeforeEvaluator.sameOrBefore(left, rightEnd, precision, context);
            return AndEvaluator.and(pointSameOrAfterStart, pointSameOrBeforeEnd);
        }
        if (AnyTrueEvaluator.anyTrue(Arrays.asList(EqualEvaluator.equal(left, right.getStart(), context), EqualEvaluator.equal(left, right.getEnd(), context))).booleanValue()) {
            return true;
        }
        if (AnyTrueEvaluator.anyTrue(Arrays.asList(LessEvaluator.less(left, right.getStart(), context), GreaterEvaluator.greater(left, right.getEnd(), context))).booleanValue()) {
            return false;
        }
        Boolean greaterOrEqual = rightStart == null && right.getLowClosed() ? Boolean.valueOf(true) : GreaterOrEqualEvaluator.greaterOrEqual(left, rightStart, context);
        Boolean lessOrEqual = rightEnd == null && right.getHighClosed() ? Boolean.valueOf(true) : LessOrEqualEvaluator.lessOrEqual(left, rightEnd, context);
        return AndEvaluator.and(greaterOrEqual, lessOrEqual);
    }

    private static Boolean listIn(Object left, Iterable<?> right, Context context) {
        for (Object element : right) {
            Boolean isEqual = EqualEvaluator.equal(left, element, context);
            if (isEqual == null || !isEqual.booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String precision = this.getPrecision() == null ? null : this.getPrecision().value();
        return InEvaluator.in(left, right, precision, context);
    }
}

