/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.Ln;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.exception.UndefinedResult;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Value;

public class LnEvaluator
extends Ln {
    public static Object ln(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof BigDecimal) {
            BigDecimal retVal;
            try {
                retVal = new BigDecimal(Math.log(((BigDecimal)operand).doubleValue()));
            }
            catch (NumberFormatException nfe) {
                if (((BigDecimal)operand).compareTo(new BigDecimal(0)) < 0) {
                    return null;
                }
                if (((BigDecimal)operand).compareTo(new BigDecimal(0)) == 0) {
                    throw new UndefinedResult("Results in negative infinity");
                }
                throw new UndefinedResult(nfe.getMessage());
            }
            return Value.verifyPrecision(retVal, null);
        }
        throw new InvalidOperatorArgument("Ln(Decimal)", String.format("Ln(%s)", operand.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        return LnEvaluator.ln(operand);
    }
}

