/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.Meets;
import org.opencds.cqf.cql.engine.elm.execution.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.InEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.MaxValueEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.MeetsAfterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.MeetsBeforeEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.OrEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SameAsEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SuccessorEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Time;

public class MeetsEvaluator
extends Meets {
    public static Boolean meetsOperation(Object left, Object right, String precision, Context context) {
        Boolean isMax;
        if (left == null && right == null) {
            return null;
        }
        Object maxValue = MaxValueEvaluator.maxValue(left != null ? left.getClass().getName() : right.getClass().getName());
        if (left instanceof BaseTemporal && right instanceof BaseTemporal) {
            isMax = SameAsEvaluator.sameAs(left, maxValue, precision, context);
            if (isMax != null && isMax.booleanValue()) {
                return false;
            }
            String tempPrecision = BaseTemporal.getHighestPrecision((BaseTemporal)left, (BaseTemporal)right);
            if (precision == null && ((BaseTemporal)left).isUncertain(Precision.fromString(tempPrecision))) {
                return SameAsEvaluator.sameAs(SuccessorEvaluator.successor(left), right, tempPrecision, context);
            }
            if (precision != null && ((BaseTemporal)left).isUncertain(Precision.fromString(precision))) {
                return SameAsEvaluator.sameAs(left, right, precision, context);
            }
            if (precision == null) {
                precision = tempPrecision;
            }
            if (left instanceof DateTime && right instanceof DateTime) {
                DateTime dt = new DateTime(((DateTime)left).getDateTime().plus(1L, Precision.fromString(precision).toChronoUnit()), ((BaseTemporal)left).getPrecision());
                return SameAsEvaluator.sameAs(dt, right, precision, context);
            }
            if (left instanceof Time) {
                Time t = new Time(((Time)left).getTime().plus(1L, Precision.fromString(precision).toChronoUnit()), ((BaseTemporal)left).getPrecision());
                return SameAsEvaluator.sameAs(t, right, precision, context);
            }
        }
        if ((isMax = EqualEvaluator.equal(left, maxValue, context)) != null && isMax.booleanValue()) {
            return false;
        }
        return EqualEvaluator.equal(SuccessorEvaluator.successor(left), right, context);
    }

    public static Boolean meets(Object left, Object right, String precision, Context context) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval && right instanceof Interval) {
            Object leftStart = ((Interval)left).getStart();
            Object leftEnd = ((Interval)left).getEnd();
            Boolean in = InEvaluator.in(leftStart, right, precision, context);
            if (in != null && in.booleanValue()) {
                return false;
            }
            in = InEvaluator.in(leftEnd, right, precision, context);
            if (in != null && in.booleanValue()) {
                return false;
            }
            return OrEvaluator.or(MeetsBeforeEvaluator.meetsBefore(left, right, precision, context), MeetsAfterEvaluator.meetsAfter(left, right, precision, context));
        }
        throw new InvalidOperatorArgument("Meets(Interval<T>, Interval<T>)", String.format("Meets(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String precision = this.getPrecision() == null ? null : this.getPrecision().value();
        return MeetsEvaluator.meets(left, right, precision, context);
    }
}

