/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.util.Iterator;
import org.cqframework.cql.elm.execution.Min;
import org.opencds.cqf.cql.engine.elm.execution.LessEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;

public class MinEvaluator
extends Min {
    public static Object min(Object source, Context context) {
        if (source == null) {
            return null;
        }
        if (source instanceof Iterable) {
            Iterable element = (Iterable)source;
            Iterator itr = element.iterator();
            if (!itr.hasNext()) {
                return null;
            }
            Object min = itr.next();
            while (min == null && itr.hasNext()) {
                min = itr.next();
            }
            while (itr.hasNext()) {
                Boolean less;
                Object value = itr.next();
                if (value == null || (less = LessEvaluator.less(value, min, context)) == null || !less.booleanValue()) continue;
                min = value;
            }
            return min;
        }
        throw new InvalidOperatorArgument("Min(List<Integer>), Min(List<Long>), Min(List<Decimal>), Min(List<Quantity>), Min(List<Date>), Min(List<DateTime>), Min(List<Time>) or Min(List<String>)", String.format("Min(%s)", source.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object source = this.getSource().evaluate(context);
        return MinEvaluator.min(source, context);
    }
}

