/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.util.stream.StreamSupport;
import org.cqframework.cql.elm.execution.ProperIncludes;
import org.opencds.cqf.cql.engine.elm.execution.AndEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.GreaterEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.IncludedInEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.NotEqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.SameAsEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;

public class ProperIncludesEvaluator
extends ProperIncludes {
    public static Boolean properlyIncludes(Object left, Object right, String precision, Context context) {
        if (left == null && right == null) {
            return null;
        }
        if (left == null) {
            return right instanceof Interval ? ProperIncludesEvaluator.intervalProperlyIncludes(null, (Interval)right, precision, context) : ProperIncludesEvaluator.listProperlyIncludes(null, (Iterable)right, context);
        }
        if (right == null) {
            return left instanceof Interval ? ProperIncludesEvaluator.intervalProperlyIncludes((Interval)left, null, precision, context) : ProperIncludesEvaluator.listProperlyIncludes((Iterable)left, null, context);
        }
        if (left instanceof Interval && right instanceof Interval) {
            return ProperIncludesEvaluator.intervalProperlyIncludes((Interval)left, (Interval)right, precision, context);
        }
        if (left instanceof Iterable && right instanceof Iterable) {
            return ProperIncludesEvaluator.listProperlyIncludes((Iterable)left, (Iterable)right, context);
        }
        throw new InvalidOperatorArgument("ProperlyIncludes(Interval<T>, Interval<T>) or ProperlyIncludes(List<T>, List<T>)", String.format("ProperlyIncludes(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    public static Boolean intervalProperlyIncludes(Interval left, Interval right, String precision, Context context) {
        if (left == null || right == null) {
            return null;
        }
        Object leftStart = left.getStart();
        Object leftEnd = left.getEnd();
        Object rightStart = right.getStart();
        Object rightEnd = right.getEnd();
        if (leftStart instanceof BaseTemporal || leftEnd instanceof BaseTemporal || rightStart instanceof BaseTemporal || rightEnd instanceof BaseTemporal) {
            Boolean isSame = AndEvaluator.and(SameAsEvaluator.sameAs(leftStart, rightStart, precision, context), SameAsEvaluator.sameAs(leftEnd, rightEnd, precision, context));
            return AndEvaluator.and(IncludedInEvaluator.intervalIncludedIn(right, left, precision, context), isSame == null ? null : Boolean.valueOf(isSame == false));
        }
        return AndEvaluator.and(IncludedInEvaluator.intervalIncludedIn(right, left, precision, context), NotEqualEvaluator.notEqual(left, right, context));
    }

    public static Boolean listProperlyIncludes(Iterable<?> left, Iterable<?> right, Context context) {
        if (left == null) {
            return false;
        }
        int leftCount = (int)StreamSupport.stream(left.spliterator(), false).count();
        if (right == null) {
            return leftCount > 0;
        }
        return AndEvaluator.and(IncludedInEvaluator.listIncludedIn(right, left, context), GreaterEvaluator.greater(leftCount, (int)StreamSupport.stream(right.spliterator(), false).count(), context));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String precision = this.getPrecision() != null ? this.getPrecision().value() : null;
        return ProperIncludesEvaluator.properlyIncludes(left, right, precision, context);
    }
}

