/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import org.cqframework.cql.elm.execution.SameOrBefore;
import org.opencds.cqf.cql.engine.elm.execution.LessOrEqualEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.BaseTemporal;
import org.opencds.cqf.cql.engine.runtime.Interval;
import org.opencds.cqf.cql.engine.runtime.Precision;

public class SameOrBeforeEvaluator
extends SameOrBefore {
    public static Boolean onOrBefore(Object left, Object right, String precision, Context context) {
        if (left instanceof Interval && right instanceof Interval) {
            if (((Interval)left).getStart() instanceof BaseTemporal) {
                return SameOrBeforeEvaluator.sameOrBefore(((Interval)left).getEnd(), ((Interval)right).getStart(), precision, context);
            }
            return LessOrEqualEvaluator.lessOrEqual(((Interval)left).getEnd(), ((Interval)right).getStart(), context);
        }
        if (left instanceof Interval) {
            if (right instanceof BaseTemporal) {
                return SameOrBeforeEvaluator.sameOrBefore(((Interval)left).getEnd(), right, precision, context);
            }
            return LessOrEqualEvaluator.lessOrEqual(((Interval)left).getEnd(), right, context);
        }
        if (right instanceof Interval) {
            if (left instanceof BaseTemporal) {
                return SameOrBeforeEvaluator.sameOrBefore(left, ((Interval)right).getStart(), precision, context);
            }
            return LessOrEqualEvaluator.lessOrEqual(left, ((Interval)right).getStart(), context);
        }
        throw new InvalidOperatorArgument("OnOrBefore(Date, Date), OnOrBefore(DateTime, DateTime), OnOrBefore(Time, Time), OnOrBefore(Interval<T>, Interval<T>), OnOrBefore(T, Interval<T>) or OnOrBefore(Interval<T>, T)", String.format("OnOrBefore(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    public static Boolean sameOrBefore(Object left, Object right, String precision, Context context) {
        if (left == null || right == null) {
            return null;
        }
        if (left instanceof Interval || right instanceof Interval) {
            return SameOrBeforeEvaluator.onOrBefore(left, right, precision, context);
        }
        if (precision == null) {
            precision = BaseTemporal.getHighestPrecision((BaseTemporal)left, (BaseTemporal)right);
        }
        if (left instanceof BaseTemporal && right instanceof BaseTemporal) {
            Integer result = ((BaseTemporal)left).compareToPrecision((BaseTemporal)right, Precision.fromString(precision));
            return result == null ? null : Boolean.valueOf(result == 0 || result < 0);
        }
        throw new InvalidOperatorArgument("SameOrBefore(Date, Date), SameOrBefore(DateTime, DateTime), SameOrBefore(Time, Time), SameOrBefore(Interval<T>, Interval<T>), SameOrBefore(T, Interval<T>) or SameOrBefore(Interval<T>, T)", String.format("SameOrBefore(%s, %s)", left.getClass().getName(), right.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object left = this.getOperand().get(0).evaluate(context);
        Object right = this.getOperand().get(1).evaluate(context);
        String precision = this.getPrecision() == null ? null : this.getPrecision().value();
        return SameOrBeforeEvaluator.sameOrBefore(left, right, precision, context);
    }
}

