/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.ToDecimal;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Value;

public class ToDecimalEvaluator
extends ToDecimal {
    public static Object toDecimal(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof Boolean) {
            return (Boolean)operand != false ? new BigDecimal("1.0") : new BigDecimal("0.0");
        }
        if (operand instanceof BigDecimal) {
            return operand;
        }
        if (operand instanceof Integer) {
            return new BigDecimal((Integer)operand);
        }
        if (operand instanceof Long) {
            return new BigDecimal((Long)operand);
        }
        if (operand instanceof String) {
            try {
                if (((String)operand).contains(".")) {
                    String[] decimalSplit = ((String)operand).split("\\.");
                    if ((decimalSplit[0].contains("-") || decimalSplit[0].contains("+")) && decimalSplit[0].length() == 1) {
                        return null;
                    }
                    if (decimalSplit[0].length() == 0) {
                        return null;
                    }
                }
                return Value.validateDecimal(new BigDecimal((String)operand), null);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        throw new InvalidOperatorArgument("ToDecimal(String)", String.format("ToDecimal(%s)", operand.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        return ToDecimalEvaluator.toDecimal(operand);
    }
}

