/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.time.format.DateTimeParseException;
import org.cqframework.cql.elm.execution.ToDate;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Precision;

public class ToDateEvaluator
extends ToDate {
    public static Object toDate(Object operand) {
        if (operand == null) {
            return null;
        }
        if (operand instanceof Date) {
            return operand;
        }
        if (operand instanceof String) {
            try {
                return new Date((String)operand);
            }
            catch (DateTimeParseException dtpe) {
                return null;
            }
        }
        if (operand instanceof DateTime) {
            return new Date(((DateTime)operand).getDateTime().toLocalDate()).setPrecision(((DateTime)operand).getPrecision().toDateTimeIndex() > 2 ? Precision.DAY : ((DateTime)operand).getPrecision());
        }
        throw new InvalidOperatorArgument("ToDate(String)", String.format("ToDate(%s)", operand.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object operand = this.getOperand().evaluate(context);
        return ToDateEvaluator.toDate(operand);
    }
}

