/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.cqframework.cql.elm.execution.HighBoundary;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Date;
import org.opencds.cqf.cql.engine.runtime.DateTime;
import org.opencds.cqf.cql.engine.runtime.Precision;
import org.opencds.cqf.cql.engine.runtime.Time;

public class HighBoundaryEvaluator
extends HighBoundary {
    public static Object highBoundary(Object input, Object precision) {
        if (input == null) {
            return null;
        }
        if (input instanceof BigDecimal) {
            if (precision == null) {
                precision = 8;
            }
            if ((Integer)precision > 8) {
                return null;
            }
            BigDecimal result = new BigDecimal(((BigDecimal)input).toPlainString() + "99999999");
            return result.setScale((int)((Integer)precision), RoundingMode.DOWN);
        }
        if (input instanceof Date) {
            if (precision == null) {
                precision = 8;
            }
            if ((Integer)precision > 8) {
                return null;
            }
            if ((Integer)precision <= 4) {
                return ((Date)input).expandPartialMax(Precision.YEAR);
            }
            if ((Integer)precision <= 6) {
                return ((Date)input).expandPartialMax(Precision.MONTH);
            }
            if ((Integer)precision <= 8) {
                return ((Date)input).expandPartialMax(Precision.DAY);
            }
        } else if (input instanceof DateTime) {
            if (precision == null) {
                precision = 17;
            }
            if ((Integer)precision > 17) {
                return null;
            }
            if ((Integer)precision <= 4) {
                return ((DateTime)input).expandPartialMax(Precision.YEAR);
            }
            if ((Integer)precision <= 6) {
                return ((DateTime)input).expandPartialMax(Precision.MONTH);
            }
            if ((Integer)precision <= 8) {
                return ((DateTime)input).expandPartialMax(Precision.DAY);
            }
            if ((Integer)precision <= 10) {
                return ((DateTime)input).expandPartialMax(Precision.HOUR);
            }
            if ((Integer)precision <= 12) {
                return ((DateTime)input).expandPartialMax(Precision.MINUTE);
            }
            if ((Integer)precision <= 14) {
                return ((DateTime)input).expandPartialMax(Precision.SECOND);
            }
            if ((Integer)precision <= 17) {
                return ((DateTime)input).expandPartialMax(Precision.MILLISECOND);
            }
        } else if (input instanceof Time) {
            if (precision == null) {
                precision = 9;
            }
            if ((Integer)precision > 9) {
                return null;
            }
            if ((Integer)precision <= 2) {
                return ((Time)input).expandPartialMax(Precision.HOUR);
            }
            if ((Integer)precision <= 4) {
                return ((Time)input).expandPartialMax(Precision.MINUTE);
            }
            if ((Integer)precision <= 6) {
                return ((Time)input).expandPartialMax(Precision.SECOND);
            }
            if ((Integer)precision <= 9) {
                return ((Time)input).expandPartialMax(Precision.MILLISECOND);
            }
        }
        throw new InvalidOperatorArgument("HighBoundary(Decimal, Integer) or HighBoundary(Date, Integer) or HighBoundary(DateTime, Integer) or HighBoundary(Time, Integer)", String.format("HighBoundary(%s, %s)", input.getClass().getName(), precision.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Object input = this.getOperand().get(0).evaluate(context);
        Object precision = this.getOperand().get(1).evaluate(context);
        return HighBoundaryEvaluator.highBoundary(input, precision);
    }
}

