/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.elm.execution;

import java.math.BigDecimal;
import org.cqframework.cql.elm.execution.Expression;
import org.cqframework.cql.elm.execution.Negate;
import org.opencds.cqf.cql.engine.elm.execution.LiteralEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidOperatorArgument;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.runtime.Quantity;

public class NegateEvaluator
extends Negate {
    public static Object negate(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Integer) {
            return -((Integer)source).intValue();
        }
        if (source instanceof Long) {
            return -((Long)source).longValue();
        }
        if (source instanceof BigDecimal) {
            return ((BigDecimal)source).negate();
        }
        if (source instanceof Quantity) {
            Quantity quantity = (Quantity)source;
            return new Quantity().withValue(quantity.getValue().negate()).withUnit(quantity.getUnit());
        }
        throw new InvalidOperatorArgument("Negate(Integer), Negate(Long), Negate(Decimal) or Negate(Quantity)", String.format("Negate(%s)", source.getClass().getName()));
    }

    @Override
    protected Object internalEvaluate(Context context) {
        Expression operand = this.getOperand();
        if (operand instanceof LiteralEvaluator && ((LiteralEvaluator)operand).getValue().equals("2147483648")) {
            return Integer.MIN_VALUE;
        }
        if (operand instanceof LiteralEvaluator && ((LiteralEvaluator)operand).getValue().equals("9223372036854775807")) {
            return Long.MIN_VALUE;
        }
        Object source = operand.evaluate(context);
        return NegateEvaluator.negate(source);
    }
}

