/*
 * Decompiled with CFR 0.152.
 */
package org.opencds.cqf.cql.engine.runtime;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.cqframework.cql.elm.execution.Expression;
import org.opencds.cqf.cql.engine.elm.execution.EqualEvaluator;
import org.opencds.cqf.cql.engine.elm.execution.EquivalentEvaluator;
import org.opencds.cqf.cql.engine.exception.InvalidComparison;
import org.opencds.cqf.cql.engine.execution.Context;
import org.opencds.cqf.cql.engine.execution.Variable;

public class CqlList {
    private Context context;
    private String alias;
    private Expression expression;
    private String path;
    public Comparator<Object> valueSort = this::compareTo;
    public Comparator<Object> expressionSort = new Comparator<Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int compare(Object left, Object right) {
            try {
                CqlList.this.context.push(new Variable().withName(CqlList.this.alias).withValue(left));
                left = CqlList.this.expression.evaluate(CqlList.this.context);
            }
            finally {
                CqlList.this.context.pop();
            }
            try {
                CqlList.this.context.push(new Variable().withName(CqlList.this.alias).withValue(right));
                right = CqlList.this.expression.evaluate(CqlList.this.context);
            }
            finally {
                CqlList.this.context.pop();
            }
            return CqlList.this.compareTo(left, right);
        }
    };
    public Comparator<Object> columnSort = new Comparator<Object>(){

        @Override
        public int compare(Object left, Object right) {
            Object leftCol = CqlList.this.context.resolvePath(left, CqlList.this.path);
            Object rightCol = CqlList.this.context.resolvePath(right, CqlList.this.path);
            return CqlList.this.compareTo(leftCol, rightCol);
        }
    };

    public CqlList() {
    }

    public CqlList(Context context, String alias, Expression expression) {
        this.context = context;
        this.alias = alias;
        this.expression = expression;
    }

    public CqlList(Context context, String path) {
        this.context = context;
        this.path = path;
    }

    public int compareTo(Object left, Object right) {
        if (left == null && right == null) {
            return 0;
        }
        if (left == null) {
            return -1;
        }
        if (right == null) {
            return 1;
        }
        try {
            return ((Comparable)left).compareTo(right);
        }
        catch (ClassCastException cce) {
            throw new InvalidComparison("Type " + left.getClass().getName() + " is not comparable");
        }
    }

    public static Boolean equivalent(Iterable<?> left, Iterable<?> right, Context context) {
        Iterator<?> leftIterator = left.iterator();
        Iterator<?> rightIterator = right.iterator();
        while (leftIterator.hasNext()) {
            Object leftObject = leftIterator.next();
            if (rightIterator.hasNext()) {
                Object rightObject = rightIterator.next();
                Boolean elementEquivalent = EquivalentEvaluator.equivalent(leftObject, rightObject, context);
                if (elementEquivalent.booleanValue()) continue;
                return false;
            }
            return false;
        }
        return !rightIterator.hasNext();
    }

    public static Boolean equal(Iterable<?> left, Iterable<?> right, Context context) {
        Iterator<?> leftIterator = left.iterator();
        Iterator<?> rightIterator = right.iterator();
        while (leftIterator.hasNext()) {
            Object leftObject = leftIterator.next();
            if (rightIterator.hasNext()) {
                Object rightObject = rightIterator.next();
                if (leftObject instanceof Iterable && rightObject instanceof Iterable) {
                    return CqlList.equal((Iterable)leftObject, (Iterable)rightObject, context);
                }
                Boolean elementEquals = EqualEvaluator.equal(leftObject, rightObject, context);
                if (elementEquals != null && elementEquals.booleanValue()) continue;
                return elementEquals;
            }
            if (leftObject == null) {
                return null;
            }
            return false;
        }
        if (rightIterator.hasNext()) {
            return rightIterator.next() == null ? null : Boolean.valueOf(false);
        }
        return true;
    }

    public static <T> List<T> toList(Iterable<T> iterable, boolean includeNullElements) {
        ArrayList<T> ret = new ArrayList<T>();
        for (T element : iterable) {
            if (element == null && !includeNullElements) continue;
            ret.add(element);
        }
        return ret;
    }
}

